/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

public class Counter {
    private volatile long value;
    private volatile long numberOfSamples;
    private volatile long low;
    private volatile long high;
    private volatile long variance100;

    private double calculatePercentile(double z) {
        return (double)this.getAverage() + z * this.getStandardDeviation();
    }

    public long getAverage() {
        return this.value / this.numberOfSamples;
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    public long getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public double getPercentile95() {
        return this.calculatePercentile(1.65);
    }

    public double getPercentile99() {
        return this.calculatePercentile(2.33);
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public long getValue() {
        return this.value;
    }

    public double getVariance() {
        if (this.numberOfSamples > 1L) {
            return (double)this.variance100 / 100.0 / (double)(this.numberOfSamples - 1L);
        }
        return 0.0;
    }

    public void increment(long amount) {
        ++this.numberOfSamples;
        this.value += amount;
        this.high = Math.max(amount, this.high);
        this.low = Math.min(amount, this.low);
        if (this.value > 1L) {
            this.high = Math.max(amount, this.high);
            this.low = Math.min(amount, this.low);
            long delta10 = amount * 10L - this.value * 10L / this.numberOfSamples;
            this.variance100 += delta10 * delta10;
        } else {
            this.high = amount;
            this.low = amount;
            this.variance100 = 0L;
        }
    }

    public void reset() {
        this.value = 0L;
        this.numberOfSamples = 0L;
        this.low = 0L;
        this.high = 0L;
        this.variance100 = 0L;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        builder.append(" (");
        builder.append(this.low);
        builder.append("/");
        builder.append(this.high);
        builder.append(")");
        return builder.toString();
    }
}

