/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.internal;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.gyrex.logback.config.internal.LogbackConfigDebug;
import org.eclipse.gyrex.logback.config.spi.AppenderProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppenderProviderRegistry
extends ServiceTracker<AppenderProvider, AppenderProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(AppenderProviderRegistry.class);
    private final ConcurrentMap<String, AppenderProvider> providerById = new ConcurrentHashMap<String, AppenderProvider>();
    private final ConcurrentMap<String, String> nameById = new ConcurrentHashMap<String, String>();

    public AppenderProviderRegistry(BundleContext context) {
        super(context, AppenderProvider.class, null);
    }

    void addAppenderProvider(AppenderProvider provider, String defaultName) {
        if (LogbackConfigDebug.providerRegistry) {
            LOG.debug("Adding appender provider: {}", (Object)provider);
        }
        Collection<String> ids = provider.getProvidedTypeIds();
        for (String id : ids) {
            AppenderProvider existing = this.providerById.putIfAbsent(id, provider);
            if (existing != null) {
                LOG.warn("Appender provider with id {} already registered. Registration of appender provider {} ignored.", (Object)id, (Object)provider);
                continue;
            }
            String name = provider.getName(id);
            this.nameById.putIfAbsent(id, name != null ? name : (defaultName != null ? defaultName : id));
        }
    }

    public AppenderProvider addingService(ServiceReference<AppenderProvider> reference) {
        AppenderProvider service = (AppenderProvider)((Object)super.addingService(reference));
        Object defaultName = reference.getProperty("service.description");
        this.addAppenderProvider(service, defaultName instanceof String ? (String)defaultName : null);
        return service;
    }

    public String getName(String appenderTypeId) {
        return (String)this.nameById.get(appenderTypeId);
    }

    public AppenderProvider getProvider(String id) {
        return (AppenderProvider)((Object)this.providerById.get(id));
    }

    public Collection<String> getAvailableTypeIds() {
        return this.providerById.keySet();
    }

    void removeAppenderProvider(AppenderProvider provider) {
        if (LogbackConfigDebug.providerRegistry) {
            LOG.debug("Removing appenders provider: {}", (Object)provider);
        }
        Collection<String> ids = provider.getProvidedTypeIds();
        for (String id : ids) {
            this.providerById.remove(id, (Object)provider);
            this.nameById.remove(id);
        }
    }

    public void removedService(ServiceReference<AppenderProvider> reference, AppenderProvider service) {
        this.removeAppenderProvider(service);
        super.removedService(reference, (Object)service);
    }
}

