/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.p2.publisher.eclipse.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProductContentType {
    BUNDLES("bundles"),
    FEATURES("features"),
    MIXED("mixed");

    private String contentTypeString;
    private static Map<String, ProductContentType> mappings;

    static {
        mappings = new HashMap<String, ProductContentType>();
        mappings.put("bundles", BUNDLES);
        mappings.put("features", FEATURES);
        mappings.put("mixed", MIXED);
    }

    private ProductContentType(String contentTypeString) {
        this.contentTypeString = contentTypeString;
    }

    public String toString() {
        return this.contentTypeString;
    }

    public static ProductContentType toProductContentType(String typeAsString) throws IllegalArgumentException {
        ProductContentType result = mappings.get(typeAsString.toLowerCase(Locale.ENGLISH));
        if (result == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.exception_invalidProductContentType, (Object)typeAsString, ProductContentType.getAllowedSetOfValues()));
        }
        return result;
    }

    public static Set<String> getAllowedSetOfValues() {
        return mappings.keySet();
    }
}

