/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHungDetectionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JobHungDetectionHelper.class);
    private static final IPath ACTIVE_JOBS = IZooKeeperLayout.PATH_JOBS_ROOT.append("active");

    public static List<String> getActiveJobs(ZooKeeperMonitor watcher) throws IllegalStateException {
        try {
            return ZooKeeperGate.get().readChildrenNames(ACTIVE_JOBS, watcher, null);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            try {
                ZooKeeperGate.get().exists(ACTIVE_JOBS, watcher);
            }
            catch (Exception e2) {
                throw new IllegalStateException("Unable to read job run info!", e2);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read job run info!", e);
        }
    }

    public static int getNumberOfActiveJobs() throws IllegalStateException {
        try {
            return ZooKeeperGate.get().readChildrenNames(ACTIVE_JOBS, null).size();
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return 0;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read job run info!", e);
        }
    }

    public static String getProcessingNodeId(String jobStorageKey, Stat stat) throws IllegalStateException {
        try {
            return ZooKeeperGate.get().readRecord(ACTIVE_JOBS.append(jobStorageKey), null, stat);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read job run info!", e);
        }
    }

    public static boolean isActive(String jobStorageKey) throws IllegalStateException {
        try {
            return ZooKeeperGate.get().exists(ACTIVE_JOBS.append(jobStorageKey));
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read job run info!", e);
        }
    }

    public static boolean isStuck(String jobStorageKey, JobImpl job, boolean logLongRunning) {
        if (job.getState() == JobState.NONE) {
            return false;
        }
        if (job.getLastQueued() < 0L) {
            LOG.debug("Job {} (state {}) has never been queued! Assuming stuck.", (Object)job.getId(), (Object)job.getState());
            return true;
        }
        long timeActive = System.currentTimeMillis() - Math.max(job.getLastQueued(), job.getLastStart());
        if (timeActive < 60000L) {
            LOG.debug("Job {} was active less then a minute ago! Assuming not stuck.", (Object)job.getId(), (Object)job.getState());
            return false;
        }
        if (JobHungDetectionHelper.isActive(jobStorageKey)) {
            if (!job.isActive()) {
                LOG.debug("Job {} marked active in the system but not set active! Assuming stuck.", (Object)job.getId(), (Object)job.getState());
                return true;
            }
            if (logLongRunning) {
                if (logLongRunning && TimeUnit.MILLISECONDS.toHours(timeActive) > 12L) {
                    LOG.error("Job {} has been active in the system for {} hours now. Please investigate.", (Object)job.getId(), (Object)TimeUnit.MILLISECONDS.toHours(timeActive));
                } else if (TimeUnit.MILLISECONDS.toHours(timeActive) > 2L) {
                    LOG.warn("Job {} has been active in the system for {} hours now.", (Object)job.getId(), (Object)TimeUnit.MILLISECONDS.toHours(timeActive));
                }
            }
            return false;
        }
        if (job.isActive()) {
            LOG.debug("Job {} (state {}) set active in the store but not marked active in the system! Assuming stuck.", (Object)job.getId(), (Object)job.getState());
            return true;
        }
        if (job.getState() == JobState.WAITING || job.getState() == JobState.ABORTING) {
            long timeInQueue = System.currentTimeMillis() - job.getLastQueued();
            if (TimeUnit.MILLISECONDS.toMinutes(timeInQueue) < 120L) {
                if (timeInQueue < 60000L) {
                    LOG.debug("Job {} is {} (queued less than a minute ago). Assuming not stuck!", (Object)job.getId(), (Object)job.getState());
                } else {
                    LOG.debug("Job {} is {} (queued {} minutes ago). Assuming not stuck!", new Object[]{job.getId(), job.getState(), TimeUnit.MILLISECONDS.toMinutes(timeInQueue)});
                }
                return false;
            }
            LOG.debug("Job {} (state {}) was queue {} minutes ago. Assuming stuck.", new Object[]{job.getId(), job.getState(), TimeUnit.MILLISECONDS.toMinutes(timeInQueue)});
            return true;
        }
        LOG.debug("Job {} is neither set active nor marked active in the system but its state is {}. Assuming stuck.", (Object)job.getId(), (Object)job.getState());
        return true;
    }

    private static String myNodeId() {
        return ((INodeEnvironment)JobsActivator.getInstance().getService(INodeEnvironment.class)).getNodeId();
    }

    /*
     * Unable to fully structure code
     */
    public static void setActive(String jobStorageKey) throws IllegalStateException {
        myNodeId = JobHungDetectionHelper.myNodeId();
        path = JobHungDetectionHelper.ACTIVE_JOBS.append(jobStorageKey);
        retries = 3;
        while (true) lbl-1000:
        // 3 sources

        {
            try {
                while (true) {
                    stat = new Stat();
                    processingNodeId = ZooKeeperGate.get().readRecord(path, null, stat);
                    if (StringUtils.isNotBlank((String)processingNodeId) && !StringUtils.equalsIgnoreCase((String)myNodeId, (String)processingNodeId)) {
                        JobHungDetectionHelper.LOG.warn("Job {} active on node {} but will now be moved to this node!", (Object)jobStorageKey, (Object)processingNodeId);
                        ZooKeeperGate.get().writeRecord(path, myNodeId, stat.getVersion());
                        return;
                    }
                    if (StringUtils.equalsIgnoreCase((String)myNodeId, (String)processingNodeId)) {
                        return;
                    }
                    if (JobsDebug.debug) {
                        JobHungDetectionHelper.LOG.debug("Creating ephemeral node for job {}...", (Object)jobStorageKey);
                    }
                    ZooKeeperGate.get().createPath(path, CreateMode.EPHEMERAL, myNodeId);
                }
            }
            catch (KeeperException.NodeExistsException e) {
                if (--retries != 0) ** GOTO lbl-1000
                throw new IllegalStateException("Unable to activate job!", e);
            }
            catch (KeeperException.BadVersionException e) {
                if (--retries != 0) continue;
                throw new IllegalStateException("Unable to activate job!", e);
            }
            break;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to set job state running!", e);
        }
    }

    /*
     * Loose catch block
     */
    public static void setInactive(String jobStorageKey) throws IllegalStateException {
        IPath path = ACTIVE_JOBS.append(jobStorageKey);
        int retries = 3;
        while (true) {
            try {
                while (true) {
                    Stat stat = new Stat();
                    String processingNodeId = ZooKeeperGate.get().readRecord(path, null, stat);
                    if (StringUtils.isNotBlank((String)processingNodeId) && !StringUtils.equalsIgnoreCase((String)JobHungDetectionHelper.myNodeId(), (String)processingNodeId)) {
                        LOG.warn("Job {} active on different node (node {})!", (Object)jobStorageKey, (Object)processingNodeId);
                        return;
                    }
                    if (JobsDebug.debug) {
                        LOG.debug("Removing ephemeral node for job {}.", (Object)jobStorageKey);
                    }
                    ZooKeeperGate.get().deletePath(path, stat.getVersion());
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                return;
            }
            catch (KeeperException.BadVersionException e) {
                if (--retries != 0) continue;
                throw new IllegalStateException("Unable to deactivate job!", e);
            }
            break;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to set job state stopped!", e);
        }
    }
}

