/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.internal.ssh;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Iterator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.equinox.console.internal.ssh.AuthorizedKeys;

public class AuthorizedKeysFileAuthenticator
implements PublickeyAuthenticator {
    private String authorizedKeysFile;

    public String getAuthorizedKeysFile() {
        return this.authorizedKeysFile;
    }

    public void setAuthorizedKeysFile(String authorizedKeysFile) {
        this.authorizedKeysFile = authorizedKeysFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        String authorizedKeysFile = this.getAuthorizedKeysFile();
        if (authorizedKeysFile == null) {
            System.err.println("No authorized_keys file configured!");
            return false;
        }
        try {
            PublicKey authorizedKey;
            AuthorizedKeys keys = new AuthorizedKeys(authorizedKeysFile);
            Iterator<PublicKey> iterator = keys.getKeys().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.isSameKey(authorizedKey = iterator.next(), key));
            return true;
        }
        catch (FileNotFoundException e) {
            System.err.println("Configured authorized_keys file not found! " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            System.err.println("Please check authorized_keys file! " + e.getMessage());
        }
        return false;
    }

    private boolean isSameKey(PublicKey k1, PublicKey k2) throws IOException {
        if (k1 instanceof DSAPublicKey && k2 instanceof DSAPublicKey) {
            return this.isSameDSAKey((DSAPublicKey)k1, (DSAPublicKey)k2);
        }
        if (k1 instanceof RSAPublicKey && k2 instanceof RSAPublicKey) {
            return this.isSameRSAKey((RSAPublicKey)k1, (RSAPublicKey)k2);
        }
        throw new IOException("Unsupported key types detected!");
    }

    private boolean isSameRSAKey(RSAPublicKey k1, RSAPublicKey k2) {
        return k1.getPublicExponent().equals(k2.getPublicExponent()) && k1.getModulus().equals(k2.getModulus());
    }

    private boolean isSameDSAKey(DSAPublicKey k1, DSAPublicKey k2) {
        return k1.getY().equals(k2.getY()) && k1.getParams().getG().equals(k2.getParams().getG()) && k1.getParams().getP().equals(k2.getParams().getP()) && k1.getParams().getQ().equals(k2.getParams().getQ());
    }
}

