/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.ObjectUtils;

public class AtomicReferenceWithFlappingDetection<V> {
    private final int historyCapacity;
    private final Deque<StateChange<V>> lastStates = new ConcurrentLinkedDeque<StateChange<V>>();
    private final AtomicReference<V> reference;

    public AtomicReferenceWithFlappingDetection(int historyCapacity) {
        this.historyCapacity = Math.max(historyCapacity, 1);
        this.reference = new AtomicReference();
    }

    public final boolean compareAndSet(V expect, V update) {
        if (!this.reference.compareAndSet(expect, update)) {
            return false;
        }
        this.recordChange(expect, update);
        return true;
    }

    public final V get() {
        return this.reference.get();
    }

    public final V getAndSet(V newValue) {
        V old = this.reference.getAndSet(newValue);
        this.recordChange(old, newValue);
        return old;
    }

    public long getLastStateChangeTimestamp() {
        if (this.lastStates.isEmpty()) {
            return 0L;
        }
        return this.lastStates.getFirst().timestamp;
    }

    public boolean isFlapping(long since, int allowedChanges) {
        if (allowedChanges > this.historyCapacity) {
            throw new IllegalArgumentException("number of allowed changes must be below history capacity");
        }
        int happendChanges = 0;
        for (StateChange<V> change : this.lastStates) {
            if (change.timestamp < since || ++happendChanges <= allowedChanges) continue;
            return true;
        }
        return happendChanges > allowedChanges;
    }

    private void recordChange(V oldValue, V newValue) {
        if (ObjectUtils.equals(oldValue, newValue)) {
            return;
        }
        this.lastStates.addFirst(new StateChange<V>(newValue, System.currentTimeMillis()));
        while (this.lastStates.size() > this.historyCapacity) {
            this.lastStates.removeLast();
        }
    }

    public final void set(V newValue) {
        this.getAndSet(newValue);
    }

    static class StateChange<V> {
        final V reference;
        final long timestamp;

        public StateChange(V reference, long timestamp) {
            this.reference = reference;
            this.timestamp = timestamp;
        }
    }
}

