/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.preferences;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.eclipse.gyrex.admin.ui.internal.widgets.AdminPageWithTree;
import org.eclipse.gyrex.admin.ui.internal.widgets.PatternFilter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesExplorer
extends AdminPageWithTree {
    public PreferencesExplorer() {
        super(0);
        this.setTitle("Preferences Explorer");
        this.setTitleToolTip("Browse Preferences");
    }

    @Override
    protected void createButtons(Composite parent) {
    }

    @Override
    protected ITreeContentProvider createContentProvider() {
        return new ViewContentProvider();
    }

    @Override
    protected Control createHeader(Composite parent) {
        return null;
    }

    @Override
    protected PatternFilter createPatternFilter() {
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        return filter;
    }

    @Override
    protected String getColumnLabel(int column) {
        return null;
    }

    @Override
    protected String getElementLabel(Object element, int column) {
        if (element instanceof Preferences) {
            return ((Preferences)element).name();
        }
        return String.valueOf(element);
    }

    @Override
    protected Object getViewerInput() {
        return ((IPreferencesService)AdminUiActivator.getInstance().getService(IPreferencesService.class)).getRootNode();
    }

    @Override
    protected boolean isColumnSortable(int column) {
        return false;
    }

    @Override
    protected void refresh() {
        this.getTreeViewer().setInput(this.getViewerInput());
    }

    @Override
    protected void updateButtons() {
    }

    static class ViewContentProvider
    implements ITreeContentProvider {
        private static final long serialVersionUID = 1L;
        private static final Object[] NO_CHILDREN = new Object[0];

        ViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parent) {
            return this.getElements(parent);
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof Preferences) {
                Preferences node = (Preferences)parent;
                try {
                    String name;
                    ArrayList<Object> children = new ArrayList<Object>();
                    String[] stringArray = node.childrenNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        name = stringArray[n2];
                        children.add(node.node(name));
                        ++n2;
                    }
                    stringArray = node.keys();
                    n = stringArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        name = stringArray[n2];
                        children.add(String.valueOf(name) + "=" + StringUtils.left((String)node.get(name, ""), (int)70));
                        ++n2;
                    }
                    return children.toArray();
                }
                catch (BackingStoreException e) {
                    return new String[]{ExceptionUtils.getRootCauseMessage((Throwable)e)};
                }
            }
            return NO_CHILDREN;
        }

        public Object getParent(Object element) {
            if (element instanceof Preferences) {
                return ((Preferences)element).parent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Preferences) {
                try {
                    return ((Preferences)element).childrenNames().length > 0 || ((Preferences)element).keys().length > 0;
                }
                catch (BackingStoreException backingStoreException) {
                    return true;
                }
            }
            return false;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }
    }
}

