/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class SyncCallTest
extends ClientBase
implements AsyncCallback.ChildrenCallback,
AsyncCallback.Children2Callback,
AsyncCallback.StringCallback,
AsyncCallback.VoidCallback {
    private CountDownLatch opsCount;
    List<Integer> results = new LinkedList<Integer>();
    Integer limit = 301;

    @Test
    public void testSync() throws Exception {
        try {
            LOG.info("Starting ZK:" + new Date().toString());
            this.opsCount = new CountDownLatch(this.limit);
            TestableZooKeeper zk = this.createClient();
            LOG.info("Beginning test:" + new Date().toString());
            int i = 0;
            while (i < 100) {
                zk.create("/test" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, this, this.results);
                ++i;
            }
            zk.sync("/test", this, this.results);
            i = 0;
            while (i < 100) {
                zk.delete("/test" + i, 0, this, this.results);
                ++i;
            }
            i = 0;
            while (i < 100) {
                zk.getChildren("/", new ClientBase.NullWatcher(), this, this.results);
                ++i;
            }
            i = 0;
            while (i < 100) {
                zk.getChildren("/", new ClientBase.NullWatcher(), this, this.results);
                ++i;
            }
            LOG.info("Submitted all operations:" + new Date().toString());
            if (!this.opsCount.await(10000L, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)("Haven't received all confirmations" + this.opsCount.getCount()));
            }
            i = 0;
            while (i < this.limit) {
                Assert.assertEquals((long)0L, (long)this.results.get(i).intValue());
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    public void processResult(int rc, String path, Object ctx, List<String> children) {
        ((List)ctx).add(rc);
        this.opsCount.countDown();
    }

    public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
        ((List)ctx).add(rc);
        this.opsCount.countDown();
    }

    public void processResult(int rc, String path, Object ctx, String name) {
        ((List)ctx).add(rc);
        this.opsCount.countDown();
    }

    public void processResult(int rc, String path, Object ctx) {
        ((List)ctx).add(rc);
        this.opsCount.countDown();
    }
}

