/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.console;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.persistence.internal.PersistenceActivator;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryProviderRegistry;
import org.eclipse.gyrex.persistence.storage.registry.IRepositoryDefinition;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class CreateRepo
extends Command {
    @Argument(index=0, metaVar="REPOSITORY-ID", usage="repository id", required=true)
    protected String repositoryId;
    @Option(name="-p", aliases={"--provider-id"}, metaVar="PROVIDER-ID", usage="provider id", required=true)
    protected String providerId;
    @Option(name="-set", aliases={"--set-preference"}, metaVar="KEY=VALUE", usage="a preference option to set", multiValued=true)
    protected Map<String, String> prefsToSet;
    @Option(name="-t", aliases={"--tags"}, metaVar="TAG", usage="tags to set", multiValued=true)
    protected List<String> tags;

    public CreateRepo() {
        super("-p <providerId> <repositorId> - creates a new repository");
    }

    protected void doExecute() throws Exception {
        RepositoryProviderRegistry providerRegistry = PersistenceActivator.getInstance().getRepositoryProviderRegistry();
        String providerInfo = providerRegistry.getRepositoryProviderInfo(this.providerId);
        IRepositoryDefinition repositoryDefinition = PersistenceActivator.getInstance().getRepositoriesManager().createRepository(this.repositoryId, this.providerId);
        if (this.prefsToSet != null && !this.prefsToSet.isEmpty()) {
            IRepositoryPreferences preferences = repositoryDefinition.getRepositoryPreferences();
            for (Map.Entry<String, String> e : this.prefsToSet.entrySet()) {
                if (e.getValue() != null) {
                    preferences.put(e.getKey(), e.getValue(), false);
                    continue;
                }
                preferences.putBoolean(e.getKey(), true, false);
            }
            preferences.flush();
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            for (String tag : this.tags) {
                if (!StringUtils.isNotBlank((String)tag)) continue;
                repositoryDefinition.addTag(tag);
            }
        }
        this.printf("Created repository %s using %s (%s)!", new Object[]{this.repositoryId, providerInfo, this.providerId});
    }
}

