/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public final class ConglomerateDescriptor
extends TupleDescriptor
implements UniqueTupleDescriptor,
Provider {
    private long conglomerateNumber;
    private String name;
    private transient String[] columnNames;
    private final boolean indexable;
    private final boolean forConstraint;
    private final IndexRowGenerator indexRowGenerator;
    private final UUID uuid;
    private final UUID tableID;
    private final UUID schemaID;

    ConglomerateDescriptor(DataDictionary dataDictionary, long l, String string, boolean bl, IndexRowGenerator indexRowGenerator, boolean bl2, UUID uUID, UUID uUID2, UUID uUID3) {
        super(dataDictionary);
        this.conglomerateNumber = l;
        this.name = string;
        this.indexable = bl;
        this.indexRowGenerator = indexRowGenerator;
        this.forConstraint = bl2;
        if (uUID == null) {
            UUIDFactory uUIDFactory = Monitor.getMonitor().getUUIDFactory();
            uUID = uUIDFactory.createUUID();
        }
        this.uuid = uUID;
        this.tableID = uUID2;
        this.schemaID = uUID3;
    }

    public long getConglomerateNumber() {
        return this.conglomerateNumber;
    }

    public void setConglomerateNumber(long l) {
        this.conglomerateNumber = l;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public UUID getTableID() {
        return this.tableID;
    }

    public UUID getSchemaID() {
        return this.schemaID;
    }

    public boolean isIndex() {
        return this.indexable;
    }

    public boolean isConstraint() {
        return this.forConstraint;
    }

    public String getConglomerateName() {
        return this.name;
    }

    public void setConglomerateName(String string) {
        this.name = string;
    }

    public IndexRowGenerator getIndexDescriptor() {
        return this.indexRowGenerator;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(135);
    }

    public String getObjectName() {
        return this.name;
    }

    public UUID getObjectID() {
        return this.uuid;
    }

    public String getClassType() {
        if (this.indexable) {
            return "Index";
        }
        return "Heap";
    }

    public String toString() {
        return "";
    }

    public String getDescriptorType() {
        if (this.indexable) {
            return "Index";
        }
        return "Table";
    }

    public String getDescriptorName() {
        return this.name;
    }

    public ConglomerateDescriptor drop(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dependencyManager.invalidateFor(this, 2, languageConnectionContext);
        ConglomerateDescriptor[] conglomerateDescriptorArray = dataDictionary.getConglomerateDescriptors(this.getConglomerateNumber());
        boolean bl = false;
        ConglomerateDescriptor conglomerateDescriptor = null;
        if (conglomerateDescriptorArray.length == 1) {
            bl = true;
        } else {
            boolean bl2;
            conglomerateDescriptor = this.describeSharedConglomerate(conglomerateDescriptorArray, true);
            IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            boolean bl3 = bl2 = this.indexRowGenerator.isUnique() && !indexRowGenerator.isUnique() || this.indexRowGenerator.isUniqueWithDuplicateNulls() && !indexRowGenerator.isUniqueWithDuplicateNulls();
            if (bl2) {
                bl = true;
            } else {
                conglomerateDescriptor = null;
            }
        }
        if (bl) {
            dataDictionary.dropStatisticsDescriptors(tableDescriptor.getUUID(), this.getUUID(), transactionController);
            transactionController.dropConglomerate(this.getConglomerateNumber());
        }
        dataDictionary.dropConglomerateDescriptor(this, transactionController);
        tableDescriptor.removeConglomerateDescriptor(this);
        return conglomerateDescriptor;
    }

    public ConglomerateDescriptor describeSharedConglomerate(ConglomerateDescriptor[] conglomerateDescriptorArray, boolean bl) throws StandardException {
        if (!this.isIndex()) {
            ConglomerateDescriptor conglomerateDescriptor = null;
            for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                if (this.getConglomerateNumber() != conglomerateDescriptorArray[i].getConglomerateNumber()) continue;
                conglomerateDescriptor = conglomerateDescriptorArray[i];
            }
            return conglomerateDescriptor;
        }
        ConglomerateDescriptor conglomerateDescriptor = null;
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            if (!conglomerateDescriptorArray[i].isIndex() || this.getConglomerateNumber() != conglomerateDescriptorArray[i].getConglomerateNumber() || bl && this.getUUID().equals(conglomerateDescriptorArray[i].getUUID()) && this.getConglomerateName().equals(conglomerateDescriptorArray[i].getConglomerateName())) continue;
            if (conglomerateDescriptorArray[i].getIndexDescriptor().isUnique()) {
                conglomerateDescriptor = conglomerateDescriptorArray[i];
                break;
            }
            if (conglomerateDescriptorArray[i].getIndexDescriptor().isUniqueWithDuplicateNulls()) {
                conglomerateDescriptor = conglomerateDescriptorArray[i];
                continue;
            }
            if (conglomerateDescriptor != null) continue;
            conglomerateDescriptor = conglomerateDescriptorArray[i];
        }
        return conglomerateDescriptor;
    }
}

