/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.application.gateway;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.http.internal.HttpDebug;
import org.eclipse.gyrex.http.internal.application.gateway.IHttpGateway;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistry;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGatewayBinding
extends ServiceTracker<IHttpGateway, IHttpGateway> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpGatewayBinding.class);
    private final Lock bindingModificationLock = new ReentrantLock();
    final IEclipsePreferences.INodeChangeListener applicationsListener = new IEclipsePreferences.INodeChangeListener(){

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            if (HttpGatewayBinding.this.isEmpty()) {
                return;
            }
            IEclipsePreferences appNode = (IEclipsePreferences)event.getChild();
            String applicationId = appNode.name();
            if (HttpDebug.gatewayBinding) {
                LOG.debug("Processing added application {}", (Object)applicationId);
            }
            appNode.addPreferenceChangeListener(HttpGatewayBinding.this.applicationActiveListener);
            if (appNode.getBoolean("active", true)) {
                HttpGatewayBinding.this.mountApp(applicationId);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (HttpGatewayBinding.this.isEmpty()) {
                return;
            }
            String applicationId = event.getChild().name();
            if (HttpDebug.gatewayBinding) {
                LOG.debug("Processing unregistered application {}", (Object)applicationId);
            }
            HttpGatewayBinding.this.unmountApp(applicationId);
        }
    };
    final IEclipsePreferences.IPreferenceChangeListener applicationActiveListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (HttpGatewayBinding.this.isEmpty()) {
                return;
            }
            if ("active".equals(event.getKey())) {
                boolean active;
                String applicationId = event.getNode().name();
                if (HttpDebug.gatewayBinding) {
                    LOG.debug("Processing activation change event for application {}", (Object)applicationId);
                }
                boolean bl = active = Boolean.TRUE.equals(event.getNewValue()) || Boolean.TRUE.toString().equals(event.getNewValue());
                if (active) {
                    HttpGatewayBinding.this.mountApp(applicationId);
                } else {
                    HttpGatewayBinding.this.unmountApp(applicationId);
                }
            }
        }
    };
    final IEclipsePreferences.IPreferenceChangeListener urlMountListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (HttpGatewayBinding.this.isEmpty()) {
                return;
            }
            String url = event.getKey();
            try {
                String unmountedApplicationId = (String)event.getOldValue();
                String mountedApplicationId = (String)event.getNewValue();
                if (unmountedApplicationId != null) {
                    if (HttpDebug.gatewayBinding) {
                        LOG.debug("Unmounting application {} from url {}", (Object)unmountedApplicationId);
                    }
                    HttpGatewayBinding.this.unmountUrl(url, unmountedApplicationId);
                }
                if (mountedApplicationId != null) {
                    if (HttpDebug.gatewayBinding) {
                        LOG.debug("Mounting application {} at url {}", (Object)unmountedApplicationId);
                    }
                    HttpGatewayBinding.this.mountUrl(url, mountedApplicationId);
                }
            }
            catch (ClassCastException e) {
                LOG.warn("Invalid preference value for url {} at node {}. {}", new Object[]{url, event.getNode(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    };
    final ApplicationManager applicationManager;
    final ApplicationProviderRegistry providerRegistry;
    final ApplicationProviderRegistry.ProviderListener providerListener = new ApplicationProviderRegistry.ProviderListener(){

        @Override
        public void providerAdded(ApplicationProviderRegistration registration) {
            Object[] services;
            Object[] objectArray = services = HttpGatewayBinding.this.getServices();
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                HttpGatewayBinding.this.refreshRegistrations((IHttpGateway)service);
                ++n2;
            }
        }

        @Override
        public void providerRemoved(ApplicationProviderRegistration providerRegistration) {
        }
    };

    public HttpGatewayBinding(BundleContext context, ApplicationManager applicationManager, ApplicationProviderRegistry providerRegistry) {
        super(context, IHttpGateway.class, null);
        this.applicationManager = applicationManager;
        this.providerRegistry = providerRegistry;
    }

    public IHttpGateway addingService(ServiceReference<IHttpGateway> reference) {
        IHttpGateway gateway = (IHttpGateway)super.addingService(reference);
        if (HttpDebug.gatewayBinding) {
            LOG.debug("New HTTP gateway {}: {}", (Object)gateway.getName(), (Object)gateway);
        }
        this.refreshRegistrations(gateway);
        return gateway;
    }

    public void close() {
        this.providerRegistry.removeProviderListener(this.providerListener);
        super.close();
        try {
            String[] childrenNames;
            ApplicationManager.getUrlsNode().removePreferenceChangeListener(this.urlMountListener);
            IEclipsePreferences applicationsNode = ApplicationManager.getAppsNode();
            applicationsNode.removeNodeChangeListener(this.applicationsListener);
            String[] stringArray = childrenNames = applicationsNode.childrenNames();
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String appId = stringArray[n2];
                ((IEclipsePreferences)applicationsNode.node(appId)).removePreferenceChangeListener(this.applicationActiveListener);
                ++n2;
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (BackingStoreException e) {
            LOG.warn("Error removing change listeners. Memory may be leaked. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public ApplicationRegistration getApplicationRegistration(String applicationId) {
        return this.applicationManager.getApplicationRegistration(applicationId);
    }

    void mountApp(String applicationId) {
        this.bindingModificationLock.lock();
        try {
            Object[] services = this.getServices();
            if (services == null) {
                return;
            }
            try {
                int i = 0;
                while (i < services.length) {
                    IHttpGateway gateway = (IHttpGateway)services[i];
                    this.mountAppAtGatway(applicationId, gateway);
                    ++i;
                }
            }
            catch (Exception e) {
                LOG.error("Error registering application {}: {}", new Object[]{applicationId, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
        finally {
            this.bindingModificationLock.unlock();
        }
    }

    private void mountAppAtGatway(String applicationId, IHttpGateway gateway) {
        this.bindingModificationLock.lock();
        try {
            try {
                if (HttpDebug.gatewayBinding) {
                    LOG.debug("Registering application {} at {}", (Object)applicationId, (Object)gateway.getName());
                }
                IEclipsePreferences urlsNode = ApplicationManager.getUrlsNode();
                String[] stringArray = urlsNode.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String url = stringArray[n2];
                    if (StringUtils.equals((String)applicationId, (String)urlsNode.get(url, null))) {
                        this.mountUrlAtGateway(url, applicationId, gateway);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                LOG.error("Error registering application {}: {}", new Object[]{applicationId, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                this.bindingModificationLock.unlock();
            }
        }
        finally {
            this.bindingModificationLock.unlock();
        }
    }

    void mountUrl(String url, String applicationId) {
        this.bindingModificationLock.lock();
        try {
            Object[] services = this.getServices();
            if (services == null) {
                return;
            }
            try {
                int i = 0;
                while (i < services.length) {
                    IHttpGateway gateway = (IHttpGateway)services[i];
                    this.mountUrlAtGateway(url, applicationId, gateway);
                    ++i;
                }
            }
            catch (Exception e) {
                LOG.error("Error registering application {}: {}", new Object[]{applicationId, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
        finally {
            this.bindingModificationLock.unlock();
        }
    }

    private void mountUrlAtGateway(String url, String applicationId, IHttpGateway gateway) {
        String existingRegistration;
        if (HttpDebug.gatewayBinding) {
            LOG.debug("Mounting url {} for application {} at {}", new Object[]{url, applicationId, gateway});
        }
        if ((existingRegistration = gateway.getUrlRegistry(this).registerIfAbsent(url, applicationId)) != null && !existingRegistration.equals(applicationId)) {
            LOG.error("Unable to register application ({}). Url ({}) already registered to application ({}).", new Object[]{applicationId, url, existingRegistration});
        }
    }

    public void open() {
        ApplicationManager.getAppsNode().addNodeChangeListener(this.applicationsListener);
        ApplicationManager.getUrlsNode().addPreferenceChangeListener(this.urlMountListener);
        this.providerRegistry.addProviderListener(this.providerListener);
        super.open();
    }

    private void refreshRegistrations(IHttpGateway gateway) {
        try {
            String[] names;
            IEclipsePreferences applicationsNode = ApplicationManager.getAppsNode();
            String[] stringArray = names = applicationsNode.childrenNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String applicationId = stringArray[n2];
                IEclipsePreferences appNode = (IEclipsePreferences)applicationsNode.node(applicationId);
                appNode.addPreferenceChangeListener(this.applicationActiveListener);
                if (appNode.getBoolean("active", true)) {
                    this.mountAppAtGatway(applicationId, gateway);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            LOG.error("Unable to read existing applications. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
        }
    }

    public void removedService(ServiceReference<IHttpGateway> reference, IHttpGateway gateway) {
        if (HttpDebug.gatewayBinding) {
            LOG.debug("Removed HTTP gateway {}: {}", (Object)gateway.getName(), (Object)gateway);
        }
        super.removedService(reference, (Object)gateway);
    }

    void unmountApp(String applicationId) {
        Object[] services = this.getServices();
        if (services == null) {
            return;
        }
        int i = 0;
        while (i < services.length) {
            IHttpGateway gateway = (IHttpGateway)services[i];
            this.unmountAppAtGatway(applicationId, gateway);
            ++i;
        }
    }

    private void unmountAppAtGatway(String applicationId, IHttpGateway gateway) {
        gateway.getUrlRegistry(this).applicationUnregistered(applicationId);
    }

    void unmountUrl(String url, String applicationId) {
        Object[] services = this.getServices();
        if (services == null) {
            return;
        }
        int i = 0;
        while (i < services.length) {
            IHttpGateway gateway = (IHttpGateway)services[i];
            this.unmountUrlAtGatway(url, applicationId, gateway);
            ++i;
        }
    }

    private void unmountUrlAtGatway(String url, String applicationId, IHttpGateway gateway) {
        gateway.getUrlRegistry(this).unregister(url);
    }
}

