/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.ErrorMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.monitoring.metrics.StatusMetric;
import org.eclipse.gyrex.monitoring.metrics.ThroughputMetric;

public class ApplicationHandlerMetrics
extends MetricSet {
    private final StatusMetric statusMetric = (StatusMetric)this.getMetric(0, StatusMetric.class);
    private final ThroughputMetric requestsMetric = (ThroughputMetric)this.getMetric(1, ThroughputMetric.class);
    private final ErrorMetric errorsMetric = (ErrorMetric)this.getMetric(2, ErrorMetric.class);

    protected ApplicationHandlerMetrics(String applicationId) {
        super(String.format("org.eclipse.gyrex.http.jetty.handler.application.%s.metric", applicationId), String.format("Metrics for Jetty Server requests handled by Gyrex application '%s'.", applicationId), new BaseMetric[]{new StatusMetric("status", "created", "not initialized"), new ThroughputMetric("requests", TimeUnit.NANOSECONDS), new ErrorMetric("errors", 5)});
    }

    public void error(int status, String reason) {
        this.errorsMetric.setLastError("Error " + status, StringUtils.trimToEmpty((String)reason));
    }

    public void error(String message, Throwable t) {
        this.errorsMetric.setLastError(message, ExceptionUtils.getFullStackTrace((Throwable)t));
    }

    public ThroughputMetric getRequestsMetric() {
        return this.requestsMetric;
    }

    public void setStatus(String status, String reasons) {
        this.statusMetric.setStatus(status, reasons);
    }
}

