/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import java.util.Collection;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.admin.ui.adapter.AdapterUtil;
import org.eclipse.gyrex.admin.ui.adapter.LabelAdapter;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.AdminPageWithTree;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.wizards.NonBlockingWizardDialog;
import org.eclipse.gyrex.admin.ui.logback.internal.AddEditAppenderWizard;
import org.eclipse.gyrex.admin.ui.logback.internal.AppenderReference;
import org.eclipse.gyrex.admin.ui.logback.internal.AppendersGroup;
import org.eclipse.gyrex.admin.ui.logback.internal.DefaultLogger;
import org.eclipse.gyrex.admin.ui.logback.internal.LogbackConfigContentProvider;
import org.eclipse.gyrex.admin.ui.logback.internal.LoggerSettingsDialog;
import org.eclipse.gyrex.admin.ui.logback.internal.LoggersGroup;
import org.eclipse.gyrex.logback.config.internal.PreferenceBasedLogbackConfigStore;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.model.FileAppender;
import org.eclipse.gyrex.logback.config.model.LogbackConfig;
import org.eclipse.gyrex.logback.config.model.Logger;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.Preferences;

public class LogbackConfigurationPage
extends AdminPageWithTree {
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_LEVEL = 1;
    private Button addAppenderButton;
    private Button addLoggerButton;
    private Button editLoggerButton;
    private Button removeButton;
    private Button editDefaultLoggerButton;
    private Button saveConfigButton;
    private LogbackConfig currentInput;

    public LogbackConfigurationPage() {
        super(2);
        this.setTitle("Logback Configuration");
        this.setTitleToolTip("Configure and assign Logback appenders and loggers.");
    }

    public void activate() {
        super.activate();
    }

    void addLoggerButtonPressed() {
        final LoggerSettingsDialog dialog = new LoggerSettingsDialog(this.getShell(), this.currentInput.getAppenders().values());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    LogbackConfigurationPage.this.currentInput.addLogger(dialog.getLogger());
                    LogbackConfigurationPage.this.getTreeViewer().refresh();
                }
            }
        });
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addAppenderButton = this.createButton(buttonsPanel, "Add Appender...");
        this.addAppenderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                LogbackConfigurationPage.this.openAppenderWizard(null);
            }
        });
        this.addLoggerButton = this.createButton(buttonsPanel, "Add Logger...");
        this.addLoggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                LogbackConfigurationPage.this.addLoggerButtonPressed();
            }
        });
        this.editLoggerButton = this.createButton(buttonsPanel, "Edit Logger...");
        this.editLoggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                LogbackConfigurationPage.this.editLoggerButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                LogbackConfigurationPage.this.removeButtonPressed();
            }
        });
        this.createButtonSeparator(buttonsPanel);
        this.editDefaultLoggerButton = this.createButton(buttonsPanel, "Edit Default Logger...");
        this.editDefaultLoggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                LogbackConfigurationPage.this.editDefaultLoggerButtonPressed();
            }
        });
        this.createButtonSeparator(buttonsPanel);
        this.saveConfigButton = this.createButton(buttonsPanel, "Save Config ...");
        this.saveConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                LogbackConfigurationPage.this.saveConfigTree(true);
            }
        });
    }

    protected ITreeContentProvider createContentProvider() {
        return new LogbackConfigContentProvider();
    }

    protected Control createHeader(Composite parent) {
        if (Platform.inDevelopmentMode()) {
            Infobox infobox = new Infobox(parent);
            infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
            infobox.addHeading("Logging in Gyrex");
            infobox.addParagraph("Gyrex makes use of <a href=\"http://logback.qos.ch/\">Logback</a> to capture logging events from the most popular logging APIs. Logback can be configured using a configuration file. This page provides an alternate way using Gyrex cloud preferences. The log configuration is stored in a central place.");
            return infobox;
        }
        return null;
    }

    void editDefaultLoggerButtonPressed() {
        final LoggerSettingsDialog dialog = new LoggerSettingsDialog(this.getShell(), this.currentInput.getDefaultLevel(), this.currentInput.getDefaultAppenders(), this.currentInput.getAppenders().values());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    LogbackConfigurationPage.this.currentInput.setDefaultLevel(dialog.getLogger().getLevel());
                    LogbackConfigurationPage.this.currentInput.setDefaultAppenders(dialog.getLogger().getAppenderReferences());
                    LogbackConfigurationPage.this.getTreeViewer().refresh();
                }
            }
        });
    }

    void editLoggerButtonPressed() {
        Object selectedElement = this.getFirstSelectedElement();
        if (!(selectedElement instanceof Logger)) {
            return;
        }
        Logger logger = (Logger)selectedElement;
        final String originalName = logger.getName();
        final LoggerSettingsDialog dialog = new LoggerSettingsDialog(this.getShell(), originalName, logger.getLevel(), logger.isInheritOtherAppenders(), logger.getAppenderReferences(), this.currentInput.getAppenders().values());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    LogbackConfigurationPage.this.currentInput.getLoggers().remove(originalName);
                    LogbackConfigurationPage.this.currentInput.addLogger(dialog.getLogger());
                    LogbackConfigurationPage.this.getTreeViewer().refresh();
                }
            }
        });
    }

    private String getAppenderName(Appender element) {
        if (element instanceof FileAppender) {
            FileAppender fileAppender = (FileAppender)element;
            StrBuilder text = new StrBuilder();
            text.append(fileAppender.getName());
            text.append(String.format(" (-> %s)", fileAppender.getFileName()));
            if (fileAppender.getThreshold() != null) {
                text.append(String.format(" [%s]", fileAppender.getThreshold()));
            }
            if (fileAppender.isSeparateLogOutputsPerMdcProperty()) {
                text.append(String.format(" [mdc:%s]", fileAppender.getSiftingMdcPropertyName()));
            }
            return text.toString();
        }
        return element.getName();
    }

    protected String getColumnLabel(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Level";
            }
        }
        return null;
    }

    protected int getElementCategory(Object element, int column) {
        if (column == 0) {
            if (element instanceof DefaultLogger) {
                return 30;
            }
            if (element instanceof AppendersGroup) {
                return 10;
            }
            if (element instanceof LoggersGroup) {
                return 20;
            }
        }
        return 100;
    }

    protected String getElementLabel(Object element, int column) {
        if (column == 0) {
            LabelAdapter labelAdapter = (LabelAdapter)AdapterUtil.getAdapter((Object)element, LabelAdapter.class);
            if (labelAdapter != null) {
                return labelAdapter.getLabel(element);
            }
            if (element instanceof Appender) {
                return this.getAppenderName((Appender)element);
            }
            if (element instanceof Logger) {
                return ((Logger)element).getName();
            }
            if (element instanceof AppenderReference) {
                return ((AppenderReference)element).getAppenderRef();
            }
            if (element instanceof DefaultLogger) {
                return "Default Logger";
            }
            if (element instanceof AppendersGroup) {
                return "Appenders";
            }
            if (element instanceof LoggersGroup) {
                return "Loggers";
            }
        } else if (column == 1) {
            if (element instanceof Logger) {
                return String.valueOf(((Logger)element).getLevel());
            }
            if (element instanceof DefaultLogger) {
                return String.valueOf(((DefaultLogger)element).getLevel());
            }
        }
        return null;
    }

    private Object getFirstSelectedElement() {
        return ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
    }

    private Shell getShell() {
        return this.getTreeViewer().getTree().getShell();
    }

    protected Object getViewerInput() {
        if (this.currentInput == null) {
            IEclipsePreferences node = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.logback.config");
            try {
                if (node.nodeExists("config")) {
                    Preferences configNode = node.node("config");
                    configNode.sync();
                    this.currentInput = new PreferenceBasedLogbackConfigStore().loadConfig(configNode);
                } else {
                    this.currentInput = new LogbackConfig();
                }
            }
            catch (AssertionError | Exception | LinkageError e) {
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.logback", "Error loading Logback configuration.", (Throwable)e), "Error");
                this.currentInput = new LogbackConfig();
            }
        }
        return this.currentInput;
    }

    protected boolean isColumnSortable(int column) {
        return column == 0;
    }

    void openAppenderWizard(final Appender appenderToEdit) {
        NonBlockingWizardDialog dialog = new NonBlockingWizardDialog(SwtUtil.getShell((Widget)this.getTreeViewer().getTree()), (IWizard)new AddEditAppenderWizard(this.currentInput, appenderToEdit));
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    LogbackConfigurationPage.this.getTreeViewer().refresh((Object)appenderToEdit);
                }
            }
        });
    }

    protected void openSelectedElement() {
        Object selectedElement = this.getFirstSelectedElement();
        if (selectedElement == null) {
            return;
        }
        if (selectedElement instanceof Logger) {
            this.editLoggerButtonPressed();
        } else if (selectedElement instanceof DefaultLogger) {
            this.editDefaultLoggerButtonPressed();
        } else if (selectedElement instanceof Appender) {
            this.openAppenderWizard((Appender)selectedElement);
        }
    }

    void removeButtonPressed() {
        Object selectedElement = this.getFirstSelectedElement();
        if (selectedElement == null) {
            return;
        }
        if (selectedElement instanceof AppenderReference) {
            AppenderReference appenderRef = (AppenderReference)selectedElement;
            Object parent = appenderRef.getParent();
            if (parent instanceof Logger) {
                ((Logger)parent).getAppenderReferences().remove(appenderRef.getAppenderRef());
            } else if (parent instanceof DefaultLogger) {
                ((DefaultLogger)parent).getAppenderReferences().remove(appenderRef.getAppenderRef());
            }
        } else if (selectedElement instanceof Logger) {
            this.currentInput.getLoggers().remove(((Logger)selectedElement).getName());
        } else if (selectedElement instanceof Appender) {
            String appenderName = ((Appender)selectedElement).getName();
            Collection loggers = this.currentInput.getLoggers().values();
            for (Logger logger : loggers) {
                logger.getAppenderReferences().remove(appenderName);
            }
            this.currentInput.getAppenders().remove(appenderName);
        }
        this.getTreeViewer().refresh();
    }

    public void saveConfigTree(boolean onSave) {
        if (onSave) {
            IEclipsePreferences node = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.logback.config");
            try {
                Preferences configNode = node.node("config");
                new PreferenceBasedLogbackConfigStore().saveConfig(this.currentInput, configNode);
                node.putLong("lastModified", System.currentTimeMillis());
                node.flush();
            }
            catch (AssertionError | Exception | LinkageError e) {
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.logback", "Error saving Logback configuration.", (Throwable)e), "Error");
                return;
            }
        }
    }

    protected void updateButtons() {
        Object selectedElement = this.getFirstSelectedElement();
        this.removeButton.setEnabled(selectedElement != null && !(selectedElement instanceof DefaultLogger));
        this.editLoggerButton.setEnabled(selectedElement instanceof Logger);
    }
}

