/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.KeeperException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeConfigurer;
import org.eclipse.gyrex.cloud.admin.INodeDescriptor;
import org.eclipse.gyrex.cloud.admin.INodeListener;
import org.eclipse.gyrex.cloud.admin.node.INodeManager;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.cloud.internal.admin.NodeConfigurer;
import org.eclipse.gyrex.cloud.internal.admin.NodeDescriptor;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperNodeInfo;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudManagerImpl
implements ICloudManager {
    private static final Logger LOG = LoggerFactory.getLogger(CloudManagerImpl.class);
    private IServiceProxy<INodeEnvironment> nodeEnvironmentService;
    private ListenerList listenerList;
    private final ZooKeeperMonitor nodesMonitor = new ZooKeeperMonitor(){

        @Override
        protected void childrenChanged(String path) {
            CloudManagerImpl.this.fireNodesChanged();
            CloudManagerImpl.this.installNodesMonitor((IPath)new Path(path));
        }

        @Override
        protected void pathCreated(String path) {
            CloudManagerImpl.this.fireNodesChanged();
            CloudManagerImpl.this.installNodesMonitor((IPath)new Path(path));
        }

        @Override
        protected void pathDeleted(String path) {
            CloudManagerImpl.this.fireNodesChanged();
            CloudManagerImpl.this.installNodesMonitor((IPath)new Path(path));
        }
    };

    @Override
    public void addNodeListener(INodeListener nodeListener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList();
            this.installNodesMonitor(IZooKeeperLayout.PATH_NODES_PENDING);
            this.installNodesMonitor(IZooKeeperLayout.PATH_NODES_APPROVED);
            this.installNodesMonitor(IZooKeeperLayout.PATH_NODES_ONLINE);
        }
        this.listenerList.add((Object)nodeListener);
    }

    @Override
    public IStatus approveNode(String nodeId) {
        try {
            ZooKeeperNodeInfo.approve(nodeId, null, null);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.gyrex.cloud", String.format("Error approving node %s. %s", nodeId, ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
    }

    void fireNodesChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INodeListener)listener).nodesChanged();
            ++n2;
        }
    }

    @Override
    public Collection<INodeDescriptor> getApprovedNodes() {
        return this.readNodes(true);
    }

    @Override
    public INodeEnvironment getLocalInfo() {
        if (this.nodeEnvironmentService == null) {
            this.nodeEnvironmentService = CloudActivator.getInstance().getServiceHelper().trackService(INodeEnvironment.class);
        }
        return (INodeEnvironment)this.nodeEnvironmentService.getService();
    }

    @Override
    public INodeConfigurer getNodeConfigurer(String nodeId) {
        return new NodeConfigurer(nodeId);
    }

    @Override
    public INodeManager getNodeManager(String nodeId) {
        return new INodeManager(){};
    }

    @Override
    public Set<String> getOnlineNodes() {
        try {
            ZooKeeperGate zk = ZooKeeperGate.get();
            List<String> names = zk.readChildrenNames(IZooKeeperLayout.PATH_NODES_ONLINE, null);
            if (names == null) {
                return Collections.emptySet();
            }
            return new HashSet<String>(names);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return Collections.emptySet();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading list of nodes. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public Collection<INodeDescriptor> getPendingNodes() {
        return this.readNodes(false);
    }

    private void installNodesMonitor(IPath nodesPath) {
        try {
            ZooKeeperGate zk = ZooKeeperGate.get();
            if (zk.exists(nodesPath, this.nodesMonitor)) {
                zk.readChildrenNames(nodesPath, this.nodesMonitor, null);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to install node monitor at node {}. {}", (Object)nodesPath, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private Collection<INodeDescriptor> readNodes(boolean approved) {
        try {
            IPath path = approved ? IZooKeeperLayout.PATH_NODES_APPROVED : IZooKeeperLayout.PATH_NODES_PENDING;
            ZooKeeperGate zk = ZooKeeperGate.get();
            List<String> names = zk.readChildrenNames(path, null);
            if (names == null) {
                return Collections.emptyList();
            }
            ArrayList<NodeDescriptor> nodes = new ArrayList<NodeDescriptor>(names.size());
            for (String nodeId : names) {
                nodes.add(new NodeDescriptor(nodeId, approved));
            }
            return Collections.unmodifiableCollection(nodes);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading list of nodes. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public void removeNodeListener(INodeListener nodeListener) {
        this.listenerList.remove((Object)nodeListener);
    }

    @Override
    public IStatus retireNode(String nodeId) {
        try {
            ZooKeeperGate zk = ZooKeeperGate.get();
            zk.deletePath(IZooKeeperLayout.PATH_NODES_APPROVED.append(nodeId));
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.gyrex.cloud", String.format("Error retiring node %s. %s", nodeId, ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
    }
}

