/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.pages.overview;

import java.lang.reflect.Method;
import java.net.InetAddress;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.pages.OverviewPageItem;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NodeShortcuts
extends OverviewPageItem {
    @Override
    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin(1, true));
        composite.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        AdminUiUtil.createHeading(composite, "Shortcuts", 1);
        Label desc = new Label(composite, 64);
        desc.setText("Some convenience shortcuts for the system.");
        desc.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        final Link restartLink = new Link(composite, 0);
        restartLink.setText("<a>Restart local node</a>");
        restartLink.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        restartLink.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                NonBlockingMessageDialogs.openConfirm(SwtUtil.getShell((Widget)restartLink), "Restart Node", String.format("Node %s will be restarted. Please confirm!", NodeShortcuts.this.getNodeId()), new DialogCallback(){
                    private static final long serialVersionUID = 1L;

                    public void dialogClosed(int returnCode) {
                        if (returnCode == 0) {
                            ServerApplication.restart();
                        }
                    }
                });
            }
        });
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getNodeId() {
        String string;
        BundleContext bundleContext = AdminUiActivator.getInstance().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference("org.eclipse.gyrex.cloud.environment.INodeEnvironment");
        Object service = bundleContext.getService(serviceReference);
        if (service == null) return String.format("running on host %s", InetAddress.getLocalHost().getHostName());
        try {
            Method method = service.getClass().getMethod("getNodeId", new Class[0]);
            string = (String)method.invoke(service, new Object[0]);
        }
        catch (Throwable throwable) {
            try {
                bundleContext.ungetService(serviceReference);
                throw throwable;
            }
            catch (Exception e) {
                return String.format("(%s)", ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        bundleContext.ungetService(serviceReference);
        return string;
    }
}

