/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class NonBlockingWizardDialog
extends WizardDialog {
    private static final long serialVersionUID = 1L;
    private final AtomicReference<DialogCallback> callbackRef = new AtomicReference();

    public NonBlockingWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
    }

    private void callDialogCallback() {
        DialogCallback callback = this.callbackRef.getAndSet(null);
        if (callback != null) {
            callback.dialogClosed(this.getReturnCode());
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.callDialogCallback();
        }
    }

    public boolean close() {
        boolean closed = super.close();
        if (closed) {
            this.callDialogCallback();
        }
        return closed;
    }

    protected void finishPressed() {
        super.finishPressed();
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.callDialogCallback();
        }
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getParentShell();
        if (shell != null) {
            Rectangle displayBounds = shell.getDisplay().getBounds();
            Point size = this.getShell().getSize();
            int x = (displayBounds.width - size.x) / 2;
            int y = (displayBounds.height - size.y) / 2;
            this.getShell().setLocation(x, y);
        }
    }

    public final int open() {
        try {
            return super.open();
        }
        catch (AssertionError | Exception | LinkageError e) {
            Policy.getStatusHandler().show((IStatus)(e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : new Status(4, "org.eclipse.gyrex.admin.ui", "Unable to open dialog. Please check the server logs.", (Throwable)e)), "Error Opening Dialog");
            return 1;
        }
    }

    public void openNonBlocking(DialogCallback callback) {
        if (!this.callbackRef.compareAndSet(null, callback)) {
            throw new IllegalStateException("Concurrent operation not supported!");
        }
        this.setBlockOnOpen(false);
        this.open();
    }
}

