/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.MultiFloatFunction;
import org.apache.solr.search.function.ValueSource;

public class MaxFloatFunction
extends MultiFloatFunction {
    public MaxFloatFunction(ValueSource[] sources) {
        super(sources);
    }

    protected String name() {
        return "max";
    }

    protected float func(int doc, DocValues[] valsArr) {
        boolean first = true;
        float val = 0.0f;
        for (DocValues vals : valsArr) {
            if (first) {
                first = false;
                val = vals.floatVal(doc);
                continue;
            }
            val = Math.max(vals.floatVal(doc), val);
        }
        return val;
    }
}

