/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.internal.widgets.ElementListSelectionDialog;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DescriptionDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.TreeListDialogField;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobType;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobTypeSelectionDialog;
import org.eclipse.gyrex.admin.ui.jobs.internal.ScheduleEntryWizard;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.registry.JobProviderRegistry;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.provider.JobProvider;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScheduleEntryWizardPage
extends WizardPage {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final long serialVersionUID = 1L;
    private final StringDialogField idField = new StringDialogField();
    private final StringButtonDialogField jobTypeField = new StringButtonDialogField(new IStringButtonAdapter(){

        public void changeControlPressed(DialogField field) {
            ScheduleEntryWizardPage.this.openJobTypeSelectionDialog();
        }
    }){

        protected Text createTextControl(Composite parent) {
            return new Text(parent, 2060);
        }
    };
    private final SelectionButtonDialogField scheduleCheckBox = new SelectionButtonDialogField(32);
    private final StringDialogField cronExpressionField = new StringDialogField();
    private final DescriptionDialogField cronMakerLinkField = new DescriptionDialogField();
    private final SelectionButtonDialogField dependsCheckBox = new SelectionButtonDialogField(32);
    private final TreeListDialogField preceedingEntriesTree = new TreeListDialogField(new ITreeListAdapter(){

        public void customButtonPressed(final TreeListDialogField field, int index) {
            if (index == 0) {
                final ElementListSelectionDialog dialog = new ElementListSelectionDialog(ScheduleEntryWizardPage.this.getShell(), (ILabelProvider)new ScheduleEntryLabelProvider());
                dialog.setTitle("Select Entry");
                dialog.setMessage("&Select an entry that will trigger a run:");
                ArrayList entries = new ArrayList(ScheduleEntryWizardPage.this.getSchedule().getEntries());
                entries.remove(ScheduleEntryWizardPage.this.getEntry());
                if (!entries.isEmpty()) {
                    dialog.setElements(entries.toArray());
                    dialog.openNonBlocking(new DialogCallback(){
                        private static final long serialVersionUID = 1L;

                        public void dialogClosed(int returnCode) {
                            Object firstResult;
                            if (returnCode == 0 && (firstResult = dialog.getFirstResult()) instanceof ScheduleEntryImpl) {
                                field.addElement(firstResult);
                            }
                        }
                    });
                } else {
                    NonBlockingMessageDialogs.openInformation((Shell)ScheduleEntryWizardPage.this.getShell(), (String)"No Entries", (String)"Sorry but there are no other entries in this schedule defined.\n\nIn order to build task chains you need to define at least two or more entries within the same schedule.", null);
                }
            }
        }

        public void doubleClicked(TreeListDialogField field) {
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            ScheduleEntryImpl entry;
            Collection precedingEntries;
            if (element instanceof ScheduleEntryImpl && !(precedingEntries = (entry = (ScheduleEntryImpl)element).getPrecedingEntries()).isEmpty()) {
                ArrayList<Object> result = new ArrayList<Object>(precedingEntries.size());
                for (String entryId : precedingEntries) {
                    try {
                        result.add(ScheduleEntryWizardPage.this.getSchedule().getEntry(entryId));
                    }
                    catch (Exception e) {
                        result.add(String.valueOf(entryId) + " (" + e.getMessage() + ")");
                    }
                }
                return result.toArray();
            }
            return NO_CHILDREN;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element instanceof ScheduleEntryImpl && !((ScheduleEntryImpl)element).getPrecedingEntries().isEmpty();
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }

        public void selectionChanged(TreeListDialogField field) {
        }
    }, new String[]{"Add...", "Remove"}, (ILabelProvider)new ScheduleEntryLabelProvider());
    private JobType jobType;
    private final ScheduleImpl schedule;
    private final ScheduleEntryImpl entry;

    static JobType findJobType(String jobTypeId) {
        JobProviderRegistry registry = JobsActivator.getInstance().getJobProviderRegistry();
        JobProvider provider = registry.getProvider(jobTypeId);
        if (provider != null) {
            return new JobType(jobTypeId, registry.getName(jobTypeId), provider);
        }
        return null;
    }

    public ScheduleEntryWizardPage(ScheduleImpl schedule, ScheduleEntryImpl entry) {
        super(ScheduleEntryWizardPage.class.getSimpleName());
        this.preceedingEntriesTree.setRemoveButtonIndex(1);
        this.setTitle("Schedule Task");
        this.setDescription(entry != null ? "Modify scheduling options of a task." : "Add a new task to a schedule.");
        this.setPageComplete(false);
        this.schedule = schedule;
        this.entry = entry;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(this.convertVerticalDLUsToPixels(200), this.convertHorizontalDLUsToPixels(400)).create());
        this.setControl((Control)composite);
        this.idField.setLabelText("Entry Id:");
        this.jobTypeField.setLabelText("Task: ");
        this.jobTypeField.setButtonLabel("Browse...");
        this.scheduleCheckBox.setLabelText("Run at specific times (cron expression):");
        this.cronExpressionField.setLabelText("");
        this.cronMakerLinkField.setLabelText("");
        this.cronMakerLinkField.setText("<small>Tip: Use <a href=\"http://cronmaker.com/\" target=\"_blank\">CronMaker</a> to generate cron expressions (but drop the seconds).</small>");
        this.dependsCheckBox.setLabelText("Run whenever one of the folloing entries run successfully:");
        this.preceedingEntriesTree.setLabelText("");
        this.scheduleCheckBox.setAttachedDialogFields(new DialogField[]{this.cronExpressionField, this.cronMakerLinkField});
        this.dependsCheckBox.setAttachedDialogFields(new DialogField[]{this.preceedingEntriesTree});
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ScheduleEntryWizardPage.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.jobTypeField.setDialogFieldListener(validateListener);
        this.scheduleCheckBox.setDialogFieldListener(validateListener);
        this.cronExpressionField.setDialogFieldListener(validateListener);
        this.dependsCheckBox.setDialogFieldListener(validateListener);
        this.preceedingEntriesTree.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, this.jobTypeField, new Separator(), this.scheduleCheckBox, this.cronExpressionField, this.cronMakerLinkField, new Separator(), this.dependsCheckBox, this.preceedingEntriesTree}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.jobTypeField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.cronExpressionField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.cronMakerLinkField.getDescriptionControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.preceedingEntriesTree.getTreeControl(null));
        if (this.getEntry() != null) {
            this.idField.setEnabled(false);
            this.jobTypeField.setEnabled(false);
            this.idField.setText(this.getEntry().getId());
            this.setJobType(ScheduleEntryWizardPage.findJobType(this.getEntry().getJobTypeId()));
            if (this.getEntry().getCronExpression() != null) {
                this.scheduleCheckBox.setSelection(true);
                this.cronExpressionField.setText(this.getEntry().getCronExpression());
            }
            if (!this.getEntry().getPrecedingEntries().isEmpty()) {
                this.dependsCheckBox.setSelection(true);
                for (String entryId : this.getEntry().getPrecedingEntries()) {
                    try {
                        this.preceedingEntriesTree.addElement((Object)this.getSchedule().getEntry(entryId));
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.preceedingEntriesTree.addElement((Object)entryId);
                    }
                }
            }
        }
    }

    public String getCronExpression() {
        return this.cronExpressionField.getText();
    }

    public ScheduleEntryImpl getEntry() {
        return this.entry;
    }

    public String getEntryId() {
        return this.idField.getText();
    }

    public String getJobTypeId() {
        return this.jobType != null ? this.jobType.id : null;
    }

    public String[] getPreceedingEntryIds() {
        List elements = this.preceedingEntriesTree.getElements();
        String[] result = new String[elements.size()];
        int i = 0;
        while (i < elements.size()) {
            result[i] = ((ScheduleEntryImpl)elements.get(i)).getId();
            ++i;
        }
        return result;
    }

    public ScheduleImpl getSchedule() {
        return this.schedule;
    }

    ScheduleEntryWizard getScheduleEntryWizard() {
        return (ScheduleEntryWizard)this.getWizard();
    }

    public boolean isScheduleUsingCronExpression() {
        return this.scheduleCheckBox.isSelected();
    }

    public boolean isScheduleUsingPreceedingEntries() {
        return this.dependsCheckBox.isSelected();
    }

    void openJobTypeSelectionDialog() {
        final JobTypeSelectionDialog dialog = new JobTypeSelectionDialog(this.getShell());
        if (this.jobType != null) {
            dialog.setInitialPattern(this.jobType.getName());
        }
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    JobType jobType = (JobType)dialog.getFirstResult();
                    ScheduleEntryWizardPage.this.setJobType(jobType);
                }
            }
        });
    }

    public void setJobType(JobType jobType) {
        if (jobType == this.jobType) {
            return;
        }
        this.jobType = jobType;
        if (jobType != null) {
            this.jobTypeField.setText(jobType.getName());
            this.getScheduleEntryWizard().initializeCurrentJobConfigurationSession(jobType.id, jobType.getName(), jobType.getWizardAdapter());
        } else {
            this.jobTypeField.setText("");
            this.getScheduleEntryWizard().clearCurrentJobConfigurationSession();
        }
        this.validate();
    }

    void validate() {
        String id = this.getEntryId();
        if (StringUtils.isNotBlank((String)id)) {
            if (!IdHelper.isValidId((String)id)) {
                this.setMessage("The entered entry id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.", 3);
                this.setPageComplete(false);
                return;
            }
            if (this.getEntry() == null && this.getSchedule().hasEntry(id)) {
                this.setMessage(String.format("Schedule '%s' already contains an entry with the specified id.", this.getSchedule().getId()), 3);
                this.setPageComplete(false);
                return;
            }
        }
        if (StringUtils.isBlank((String)id)) {
            this.setMessage("Please enter an entry identifier.", 1);
            this.setPageComplete(false);
            return;
        }
        if (this.jobType == null || StringUtils.isBlank((String)this.getJobTypeId())) {
            this.setMessage("Please select a task.", 1);
            this.setPageComplete(false);
            return;
        }
        if (this.isScheduleUsingCronExpression()) {
            String cronExpression = this.getCronExpression();
            if (StringUtils.isNotBlank((String)cronExpression)) {
                try {
                    ScheduleEntryImpl.validateCronExpression((String)cronExpression);
                }
                catch (IllegalArgumentException e) {
                    this.setMessage("The cron expression is invalid. " + e.getMessage(), 3);
                    this.setPageComplete(false);
                    return;
                }
            } else {
                this.setMessage("Please enter a cron expression.", 1);
                this.setPageComplete(false);
                return;
            }
        }
        if (this.isScheduleUsingPreceedingEntries()) {
            if (this.preceedingEntriesTree.getElements().isEmpty()) {
                this.setMessage("Please select an entry this task depends on.", 1);
                this.setPageComplete(false);
                return;
            }
            if (this.entry != null) {
                String[] preceedingEntryIds;
                String[] stringArray = preceedingEntryIds = this.getPreceedingEntryIds();
                int n = preceedingEntryIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String preceedingEntryId = stringArray[n2];
                    LinkedList<String> sequence = new LinkedList<String>();
                    sequence.add(this.entry.getId());
                    try {
                        ScheduleImpl.checkExecutionSequenceForLoops((IScheduleEntry)this.entry, sequence, Collections.singletonList(preceedingEntryId));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.setMessage(String.format("Preceeding entry %s will produce a loop. Please remove it!", preceedingEntryId), 3);
                        this.setPageComplete(false);
                        return;
                    }
                    ++n2;
                }
            }
        }
        this.setMessage(null);
        this.setPageComplete(true);
    }

    private final class ScheduleEntryLabelProvider
    extends LabelProvider {
        private static final long serialVersionUID = 1L;

        private ScheduleEntryLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ScheduleEntryImpl) {
                return ((ScheduleEntryImpl)element).getId();
            }
            return super.getText(element);
        }
    }
}

