/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.locking;

import java.util.concurrent.TimeoutException;
import org.eclipse.gyrex.cloud.internal.locking.LockAcquirationFailedException;
import org.eclipse.gyrex.cloud.internal.locking.ZooKeeperLock;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.services.locking.IDurableLock;
import org.eclipse.gyrex.cloud.services.locking.ILockMonitor;

public class DurableLockImpl
extends ZooKeeperLock<IDurableLock>
implements IDurableLock {
    public DurableLockImpl(String lockId, ILockMonitor<IDurableLock> lockMonitor) {
        super(lockId, lockMonitor, IZooKeeperLayout.PATH_LOCKS_DURABLE, false, true);
    }

    public IDurableLock acquire(long timeout) throws InterruptedException, TimeoutException {
        return (IDurableLock)this.acquire(timeout, false, null);
    }

    @Override
    public String getRecoveryKey() {
        String recoveryKey = this.myRecoveryKey;
        if (recoveryKey == null) {
            throw new IllegalStateException("recovery key not available; lock must be acquired");
        }
        return recoveryKey;
    }

    public IDurableLock recover(String recoveryKey) {
        try {
            return (IDurableLock)this.acquire(100L, true, recoveryKey);
        }
        catch (InterruptedException interruptedException) {
            throw new LockAcquirationFailedException(this.getId(), "Recovery operation has been interrupted.");
        }
        catch (TimeoutException timeoutException) {
            throw new LockAcquirationFailedException(this.getId(), "Recovery operation has been timed out.");
        }
    }
}

