/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.admin;

import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class X500PrincipalHelper {
    public static int LEASTSIGNIFICANT = 0;
    public static int MOSTSIGNIFICANT = 1;
    public static final String attrCN = "CN";
    public static final String attrOU = "OU";
    public static final String attrO = "O";
    public static final String attrC = "C";
    public static final String attrL = "L";
    public static final String attrST = "ST";
    public static final String attrSTREET = "STREET";
    public static final String attrEMAIL = "EMAILADDRESS";
    public static final String attrUID = "UID";
    ArrayList<ArrayList<String>> rdnNameArray = new ArrayList();
    private static final String attrTerminator = "=";

    public X500PrincipalHelper() {
    }

    public X500PrincipalHelper(X500Principal principal) {
        this.parseDN(principal.getName("RFC2253"));
    }

    private String findPart(String attributeID) {
        return this.findSignificantPart(attributeID, MOSTSIGNIFICANT);
    }

    private String findSignificantPart(String attributeID, int significance) {
        String retNamePart = null;
        String searchPart = String.valueOf(attributeID) + attrTerminator;
        for (ArrayList<String> nameList : this.rdnNameArray) {
            String namePart = nameList.get(0);
            if (!namePart.startsWith(searchPart)) continue;
            retNamePart = namePart.toString().substring(searchPart.length());
            if (significance == MOSTSIGNIFICANT) break;
        }
        return retNamePart;
    }

    public ArrayList getAllValues(String attributeID) {
        ArrayList<String> retList = new ArrayList<String>();
        String searchPart = String.valueOf(attributeID) + attrTerminator;
        for (ArrayList<String> nameList : this.rdnNameArray) {
            String namePart = nameList.get(0);
            if (!namePart.startsWith(searchPart)) continue;
            retList.add(namePart.toString().substring(searchPart.length()));
        }
        return retList;
    }

    public String getC() {
        return this.findPart(attrC);
    }

    public String getCN() {
        return this.findPart(attrCN);
    }

    public String getEMAILDDRESS() {
        return this.findPart(attrEMAIL);
    }

    public String getL() {
        return this.findPart(attrL);
    }

    public String getO() {
        return this.findPart(attrO);
    }

    public String getOU() {
        return this.findPart(attrOU);
    }

    public String getST() {
        return this.findPart(attrST);
    }

    public String getSTREET() {
        return this.findPart(attrSTREET);
    }

    public String getUID() {
        return this.findPart(attrUID);
    }

    private void parseDN(String dn) throws IllegalArgumentException {
        int startIndex = 0;
        char c = '\u0000';
        ArrayList<String> nameValues = new ArrayList<String>();
        this.rdnNameArray.clear();
        while (startIndex < dn.length()) {
            int endIndex = startIndex;
            while (endIndex < dn.length()) {
                c = dn.charAt(endIndex);
                if (c == ',' || c == '+') break;
                if (c == '\\') {
                    ++endIndex;
                }
                ++endIndex;
            }
            if (endIndex > dn.length()) {
                throw new IllegalArgumentException("unterminated escape " + dn);
            }
            nameValues.add(dn.substring(startIndex, endIndex));
            if (c != '+') {
                this.rdnNameArray.add(nameValues);
                nameValues = endIndex != dn.length() ? new ArrayList() : null;
            }
            startIndex = endIndex + 1;
        }
        if (nameValues != null) {
            throw new IllegalArgumentException("improperly terminated DN " + dn);
        }
    }

    public void setPrincipal(X500Principal principal) {
        this.parseDN(principal.getName("RFC2253"));
    }
}

