/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.derby.internal;

import javax.sql.ConnectionPoolDataSource;
import org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource;
import org.eclipse.gyrex.persistence.jdbc.internal.SimpledPooledJdbcRepositoryImpl;
import org.eclipse.gyrex.persistence.jdbc.storage.JdbcRepository;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;

public class DerbyRepositoryType
extends RepositoryProvider {
    public static final String TYPE_ID = "org.eclipse.gyrex.persistence.derby.type";

    public DerbyRepositoryType() {
        super(TYPE_ID, JdbcRepository.class);
    }

    private EmbeddedConnectionPoolDataSource createDataSource(String databaseName) {
        EmbeddedConnectionPoolDataSource embeddedConnectionPoolDataSource = new EmbeddedConnectionPoolDataSource();
        embeddedConnectionPoolDataSource.setDatabaseName(databaseName);
        embeddedConnectionPoolDataSource.setCreateDatabase("create");
        return embeddedConnectionPoolDataSource;
    }

    private Repository createJdbcRepository(String repositoryId, EmbeddedConnectionPoolDataSource embeddedConnectionPoolDataSource) {
        return new SimpledPooledJdbcRepositoryImpl(repositoryId, (RepositoryProvider)this, (ConnectionPoolDataSource)embeddedConnectionPoolDataSource, 0);
    }

    public Repository createRepositoryInstance(String repositoryId, IRepositoryPreferences repositoryPreferences) {
        EmbeddedConnectionPoolDataSource embeddedConnectionPoolDataSource = this.createDataSource(repositoryId);
        return this.createJdbcRepository(repositoryId, embeddedConnectionPoolDataSource);
    }
}

