/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.mongodb.internal;

import com.mongodb.DB;
import com.mongodb.Mongo;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.gyrex.persistence.mongodb.MongoDbRepository;
import org.eclipse.gyrex.persistence.mongodb.internal.MongoDbActivator;
import org.eclipse.gyrex.persistence.mongodb.internal.MongoDbRepositoryProvider;
import org.eclipse.gyrex.persistence.storage.exceptions.ResourceFailureException;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;

public class MongoDbRepositoryImpl
extends MongoDbRepository {
    private final String databaseName;
    private final String poolId;
    private final AtomicReference<Mongo> mongoRef = new AtomicReference();

    public MongoDbRepositoryImpl(String repositoryId, MongoDbRepositoryProvider repositoryProvider, IRepositoryPreferences repositoryPreferences) throws IllegalArgumentException {
        super(repositoryId, repositoryProvider, null);
        this.databaseName = repositoryPreferences.get("db", null);
        this.poolId = repositoryPreferences.get("poolId", null);
    }

    protected void doClose() {
        Mongo mongo = this.mongoRef.getAndSet(null);
        if (mongo != null) {
            MongoDbActivator.getInstance().getRegistry().unget(this.poolId);
        }
        super.doClose();
    }

    private Mongo ensureInitialized() {
        if (this.poolId == null) {
            throw new IllegalStateException("pool not configured");
        }
        Mongo mongo = this.mongoRef.get();
        while (mongo == null) {
            mongo = MongoDbActivator.getInstance().getRegistry().get(this.poolId);
            if (mongo == null) {
                throw new ResourceFailureException(String.format("Pool '%s' not available!", String.valueOf(this.poolId)));
            }
            if (this.mongoRef.compareAndSet(null, mongo)) continue;
            mongo = this.mongoRef.get();
        }
        return mongo;
    }

    @Override
    public DB getDb() {
        if (this.databaseName == null) {
            throw new IllegalStateException("database not configured");
        }
        return this.ensureInitialized().getDB(this.databaseName);
    }
}

