/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.internal.solr.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.search.facets.IFacet;
import org.eclipse.gyrex.search.internal.solr.query.AttributeFilter;
import org.eclipse.gyrex.search.internal.solr.query.FacetFilter;
import org.eclipse.gyrex.search.query.IAttributeFilter;
import org.eclipse.gyrex.search.query.IFacetFilter;
import org.eclipse.gyrex.search.query.IQuery;
import org.eclipse.gyrex.search.query.ResultProjection;
import org.eclipse.gyrex.search.query.SortDirection;

public class QueryImpl
extends PlatformObject
implements IQuery {
    private String query;
    private String advancedQuery;
    private long startIndex = 0L;
    private int maxResults = 10;
    private ResultProjection resultProjection = ResultProjection.COMPACT;
    private Map<String, IFacet> facetsInUse;
    private final List<String> filterQueries = new ArrayList<String>(4);
    private final List<IAttributeFilter> attributeFilters = new ArrayList<IAttributeFilter>(4);
    private final List<IFacetFilter> facetFilters = new ArrayList<IFacetFilter>(4);
    private final LinkedHashMap<String, SortDirection> sortFields = new LinkedHashMap(2);
    private final LinkedHashMap<String, String> queryOptions = new LinkedHashMap(2);

    @Override
    public IAttributeFilter addAttributeFilter(String attributeId) {
        AttributeFilter filter = new AttributeFilter(attributeId);
        this.attributeFilters.add(filter);
        return filter;
    }

    @Override
    public IFacetFilter addFacetFilter(IFacet facet) {
        FacetFilter filter = new FacetFilter(facet);
        this.facetFilters.add(filter);
        return filter;
    }

    @Override
    public QueryImpl addFilterQuery(String filterQuery) {
        if (StringUtils.isNotBlank((String)filterQuery)) {
            this.filterQueries.add(filterQuery);
        }
        return this;
    }

    @Override
    public QueryImpl addSortField(String fieldName, SortDirection direction) {
        if (StringUtils.isNotBlank((String)fieldName)) {
            this.sortFields.remove(fieldName);
            this.sortFields.put(fieldName, direction);
        }
        return this;
    }

    @Override
    public String getAdvancedQuery() {
        return this.advancedQuery;
    }

    @Override
    public List<IAttributeFilter> getAttributeFilters() {
        return Collections.unmodifiableList(this.attributeFilters);
    }

    @Override
    public List<IFacetFilter> getFacetFilters() {
        return Collections.unmodifiableList(this.facetFilters);
    }

    public Map<String, IFacet> getFacetsInUse() {
        return this.facetsInUse;
    }

    @Override
    public List<String> getFilterQueries() {
        return Collections.unmodifiableList(this.filterQueries);
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Map<String, String> getQueryOptions() {
        return Collections.unmodifiableMap(this.queryOptions);
    }

    @Override
    public ResultProjection getResultProjection() {
        return this.resultProjection;
    }

    @Override
    public Map<String, SortDirection> getSortFields() {
        return Collections.unmodifiableMap(this.sortFields);
    }

    @Override
    public long getStartIndex() {
        return this.startIndex;
    }

    @Override
    public QueryImpl setAdvancedQuery(String advancedQuery) {
        this.advancedQuery = StringUtils.isNotEmpty((String)advancedQuery) ? advancedQuery : null;
        return this;
    }

    public void setFacetsInUse(Map<String, IFacet> facetsInUse) {
        this.facetsInUse = facetsInUse;
    }

    @Override
    public QueryImpl setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("maxResults must not be negative");
        }
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public QueryImpl setQuery(String query) {
        this.query = query;
        return this;
    }

    @Override
    public IQuery setQueryOption(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (value != null) {
            this.queryOptions.put(name, value);
        } else {
            this.queryOptions.remove(name);
        }
        return this;
    }

    @Override
    public void setResultProjection(ResultProjection resultProjection) {
        this.resultProjection = resultProjection;
    }

    @Override
    public QueryImpl setSortField(String fieldName, SortDirection direction) {
        this.sortFields.clear();
        if (StringUtils.isNotBlank((String)fieldName)) {
            this.sortFields.put(fieldName, direction);
        }
        return this;
    }

    @Override
    public QueryImpl setStartIndex(long startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append("SolrQuery[");
        if (this.advancedQuery != null) {
            toString.append(" advancedQuery(").append(this.advancedQuery).append(')');
        }
        if (this.query != null) {
            toString.append(" query(").append(this.query).append(')');
        }
        toString.append(" filterQueries(").append(this.filterQueries).append(')');
        toString.append(" sortFields(").append(this.sortFields).append(')');
        toString.append(" startIndex(").append(this.startIndex).append(')');
        toString.append(" maxResults(").append(this.maxResults).append(')');
        toString.append(" queryOptions(").append(this.queryOptions).append(')');
        toString.append(" ]");
        return toString.toString();
    }
}

