/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.internal;

import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.monitoring.metrics.StatusMetric;

public class DiagnosticsStatusMetrics
extends MetricSet {
    public static final String ID = "org.eclipse.gyrex.monitoring.diagnostics.status";
    private final StatusMetric statusMetric = this.getMetric(0, StatusMetric.class);

    static String getFormattedMessage(IStatus[] children, int ident) {
        StrBuilder builder = new StrBuilder();
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            builder.appendSeparator(SystemUtils.LINE_SEPARATOR);
            builder.appendPadding(ident, ' ');
            builder.append(DiagnosticsStatusMetrics.getSeverityText(child.getSeverity())).append(": ");
            builder.append(child.getMessage());
            if (child.getCode() != 0) {
                builder.append(" (code ").append(child.getCode()).append(")");
            }
            if (child.isMultiStatus()) {
                builder.appendNewLine();
                builder.append(DiagnosticsStatusMetrics.getFormattedMessage(child.getChildren(), ident + 2));
            }
            ++n2;
        }
        return builder.toString();
    }

    private static String getSeverityText(int severity) {
        switch (severity) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
        }
        return "UNKNOWN";
    }

    public DiagnosticsStatusMetrics() {
        super(ID, "Collection of diagnostics status metrics", new StatusMetric("status", "unknown", "not initialized"));
    }

    public void setStatus(IStatus systemStatus) {
        this.statusMetric.setStatus(DiagnosticsStatusMetrics.getSeverityText(systemStatus.getSeverity()), DiagnosticsStatusMetrics.getFormattedMessage(systemStatus.getChildren(), 0));
    }
}

