/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.pages.OverviewPageItem;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.pages.AdminPage;
import org.eclipse.gyrex.common.internal.services.IServiceProxyChangeListener;
import org.eclipse.gyrex.common.internal.services.ServiceProxy;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class OverviewPage
extends AdminPage {
    private Composite overviewPageComposite;
    private IServiceProxy<OverviewPageItem> itemServiceProxy;
    private List<Control> itemControls;
    private IServiceProxyChangeListener layoutOnServiceChange;

    public OverviewPage() {
        this.setTitle("Gyrex System Overview");
        this.setTitleToolTip("Welcome to Gyrex");
    }

    @Override
    public void activate() {
        super.activate();
        if (this.itemServiceProxy == null) {
            this.itemServiceProxy = AdminUiActivator.getInstance().getServiceHelper().trackService(OverviewPageItem.class);
        }
        List items = this.itemServiceProxy.getServices();
        this.itemControls = new ArrayList<Control>(items.size());
        for (OverviewPageItem item : items) {
            this.itemControls.add(item.createControl(this.overviewPageComposite));
        }
        final Display display = this.overviewPageComposite.getDisplay();
        this.layoutOnServiceChange = new IServiceProxyChangeListener(){

            public boolean serviceChanged(IServiceProxy<?> proxy) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OverviewPage.this.doLayout();
                    }
                });
                return false;
            }
        };
        ((ServiceProxy)this.itemServiceProxy).addChangeListener(this.layoutOnServiceChange);
        this.doLayout();
    }

    @Override
    public Control createControl(Composite parent) {
        this.overviewPageComposite = new Composite(parent, 0);
        this.overviewPageComposite.setLayout((Layout)AdminUiUtil.createMainLayout(3));
        if (Platform.inDevelopmentMode()) {
            Infobox infobox = new Infobox(this.overviewPageComposite);
            GridData gd = AdminUiUtil.createHorzFillData();
            gd.horizontalSpan = 3;
            infobox.setLayoutData(gd);
            infobox.addHeading("Welcome to Gyrex.");
            infobox.addParagraph("Your system is running and ready for administration. If you like what you see here, please follow our <a href=\"http://www.eclipse.org/gyrex/\">blog</a>.");
            infobox.addParagraph("This box only appears in development mode. A Gyrex node can opperate in different modes which influence the default configuration of the system. Development mode is the default mode and provides an environment that reduces the amount of setup work for developers. For example, a service such as Apache ZooKeeper which typically runs on different nodes in a production system, is started automatically within the Gyrex Java VM in development mode.");
        }
        return this.overviewPageComposite;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.itemServiceProxy != null && this.layoutOnServiceChange != null) {
            ((ServiceProxy)this.itemServiceProxy).removeChangeListener(this.layoutOnServiceChange);
            this.layoutOnServiceChange = null;
        }
    }

    void doLayout() {
        if (!this.overviewPageComposite.isDisposed()) {
            this.overviewPageComposite.layout();
        }
    }
}

