/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.servlets;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.admin.ui.internal.jetty.AdminServletHolder;
import org.eclipse.gyrex.admin.ui.internal.servlets.IAdminServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServletTracker
extends ServiceTracker<IAdminServlet, AdminServletHolder> {
    private static final Logger LOG = LoggerFactory.getLogger(AdminServletTracker.class);
    private final ServletContextHandler contextHandler;

    public AdminServletTracker(BundleContext context, ServletContextHandler contextHandler) {
        super(context, IAdminServlet.class, null);
        this.contextHandler = contextHandler;
    }

    public AdminServletHolder addingService(ServiceReference<IAdminServlet> reference) {
        IAdminServlet servlet = (IAdminServlet)this.context.getService(reference);
        if (servlet == null) {
            return null;
        }
        AdminServletHolder holder = new AdminServletHolder(servlet);
        Object alias = reference.getProperty("http.alias");
        if (alias instanceof String) {
            String pathSpec = (String)alias;
            if (!StringUtils.endsWith((String)pathSpec, (String)"/*")) {
                pathSpec = String.valueOf(StringUtils.removeEnd((String)pathSpec, (String)"/")) + "/*";
            }
            try {
                this.contextHandler.getServletHandler().addServlet((ServletHolder)holder);
                ServletMapping mapping = new ServletMapping();
                mapping.setPathSpec(pathSpec);
                mapping.setServletName(holder.getName());
                holder.setServletMapping(mapping);
                this.contextHandler.getServletHandler().addServletMapping(mapping);
            }
            catch (Exception e) {
                LOG.error("Error registering contributed servlet {} ({}). {}", new Object[]{reference, pathSpec, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
        return holder;
    }

    public void removedService(ServiceReference<IAdminServlet> reference, AdminServletHolder holder) {
        try {
            ServletMapping[] mappings = this.contextHandler.getServletHandler().getServletMappings();
            ArrayList<ServletMapping> newMappings = new ArrayList<ServletMapping>();
            ServletMapping[] servletMappingArray = mappings;
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                ServletMapping servletMapping = servletMappingArray[n2];
                if (servletMapping != holder.getServletMapping()) {
                    newMappings.add(servletMapping);
                }
                ++n2;
            }
            this.contextHandler.getServletHandler().setServletMappings(newMappings.toArray(new ServletMapping[newMappings.size()]));
            ServletHolder[] holders = this.contextHandler.getServletHandler().getServlets();
            ArrayList<ServletHolder> newHolders = new ArrayList<ServletHolder>();
            ServletHolder[] servletHolderArray = holders;
            int n3 = holders.length;
            int n4 = 0;
            while (n4 < n3) {
                ServletHolder servletHolder = servletHolderArray[n4];
                if (holder != servletHolder) {
                    newHolders.add(servletHolder);
                }
                ++n4;
            }
            this.contextHandler.getServletHandler().setServlets(newHolders.toArray(new ServletHolder[newHolders.size()]));
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

