/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingTrayDialog;
import org.eclipse.gyrex.admin.ui.internal.widgets.WidgetMessages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class SelectionDialog
extends NonBlockingTrayDialog {
    private static final long serialVersionUID = 1L;
    private Object[] result;
    private List<Object> initialSelections = new ArrayList<Object>();
    private String title;
    private String message = "";
    private int dialogBoundsStrategy = 3;
    private IDialogSettings dialogBoundsSettings = null;
    final String SELECT_ALL_TITLE;
    final String DESELECT_ALL_TITLE;

    protected SelectionDialog(Shell parentShell) {
        super(parentShell);
        this.SELECT_ALL_TITLE = WidgetMessages.get().SelectionDialog_selectLabel;
        this.DESELECT_ALL_TITLE = WidgetMessages.get().SelectionDialog_deselectLabel;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.get().OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.get().CANCEL_LABEL, false);
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        label.setFont(composite.getFont());
        return label;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected int getDialogBoundsStrategy() {
        return this.dialogBoundsStrategy;
    }

    protected List getInitialElementSelections() {
        return this.initialSelections;
    }

    protected String getMessage() {
        return this.message;
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    public Object[] getResult() {
        return this.result;
    }

    protected boolean isResizable() {
        return true;
    }

    public void setDialogBoundsSettings(IDialogSettings settings, int strategy) {
        this.dialogBoundsStrategy = strategy;
        this.dialogBoundsSettings = settings;
    }

    public void setInitialElementSelections(List<Object> selectedElements) {
        this.initialSelections = selectedElements;
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.initialSelections = new ArrayList<Object>(selectedElements.length);
        Object[] objectArray = selectedElements;
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedElement = objectArray[n2];
            this.initialSelections.add(selectedElement);
            ++n2;
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void setResult(List<?> newResult) {
        if (newResult == null) {
            this.result = null;
        } else {
            this.result = new Object[newResult.size()];
            newResult.toArray(this.result);
        }
    }

    protected void setSelectionResult(Object[] newResult) {
        this.result = newResult;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

