/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.internal;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.monitoring.internal.mbeans.MetricSetMBean;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricSetTracker
extends ServiceTracker<MetricSet, MetricSetJmxRegistration> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricSetTracker.class);

    public MetricSetTracker(BundleContext context) {
        super(context, MetricSet.class, null);
    }

    public MetricSetJmxRegistration addingService(ServiceReference<MetricSet> reference) {
        MetricSet metricSet = (MetricSet)this.context.getService(reference);
        if (metricSet == null) {
            return null;
        }
        try {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = this.getObjectName(reference, metricSet);
            beanServer.registerMBean(new MetricSetMBean(metricSet, reference), objectName);
            return new MetricSetJmxRegistration(objectName, metricSet);
        }
        catch (Exception e) {
            LOG.warn("Failed to expose metric {} using JMX. {}", (Object)metricSet, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private ObjectName getObjectName(ServiceReference<MetricSet> reference, MetricSet metricSet) throws MalformedObjectNameException {
        String symbolicName = reference.getBundle().getSymbolicName();
        String[] propertyKeys = reference.getPropertyKeys();
        Hashtable<String, String> properties = new Hashtable<String, String>(propertyKeys.length + 2);
        properties.put("type", "MetricSet");
        properties.put("name", StringUtils.removeStart((String)metricSet.getId(), (String)(String.valueOf(symbolicName) + ".")));
        properties.put("service.id", String.valueOf(reference.getProperty("service.id")));
        for (Map.Entry<String, String> property : metricSet.getProperties().entrySet()) {
            properties.put("metric.".concat(property.getKey()), property.getValue());
        }
        return new ObjectName(symbolicName, properties);
    }

    public void removedService(ServiceReference<MetricSet> reference, MetricSetJmxRegistration metricSetJmxRegistration) {
        try {
            try {
                MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
                beanServer.unregisterMBean(metricSetJmxRegistration.objectName);
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister metric JMX registration {}. {}", (Object)metricSetJmxRegistration.objectName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                this.context.ungetService(reference);
            }
        }
        finally {
            this.context.ungetService(reference);
        }
    }

    static class MetricSetJmxRegistration {
        final ObjectName objectName;
        final MetricSet metricSet;

        MetricSetJmxRegistration(ObjectName objectName, MetricSet metricSet) {
            this.objectName = objectName;
            this.metricSet = metricSet;
        }
    }
}

