/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.eclipse.gyrex.monitoring.metrics.CapacityMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricAttribute;

public class PoolMetric
extends CapacityMetric {
    private volatile long channelsIdle;
    private volatile long channelsMinimum;
    private volatile long resourcesStatsReleased;
    private volatile long resourcesStatsDestroyed;
    private volatile long resourcesStatsCreated;

    public PoolMetric(String id, long initialChannelsCapacity, long initialChannelsMinimum) {
        super(id, initialChannelsCapacity);
        this.channelsMinimum = initialChannelsMinimum;
    }

    public void channelBusy() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            --this.channelsIdle;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void channelIdle() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            ++this.channelsIdle;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    void doResetStats() {
        this.resourcesStatsCreated = 0L;
        this.resourcesStatsReleased = 0L;
        this.resourcesStatsDestroyed = 0L;
        super.doResetStats();
    }

    @Override
    Object[] dumpMetrics() {
        return new Object[]{"used|idle|capacity|min|high|requests|denied|wait|average wait|resources created|resources released|resources destroyed", this.getChannelsUsed(), this.getChannelsIdle(), this.getChannelsCapacity(), this.getChannelsMinimum(), this.getChannelsStatsHigh(), this.getChannelsStatsRequests(), this.getChannelsStatsDenied(), this.getChannelsStatsWaitTime(), this.getChannelsStatsWaitTimeAverage(), this.getResourcesStatsCreated(), this.getResourcesStatsReleased(), this.getResourcesStatsDestroyed()};
    }

    public long getChannelsIdle() {
        return this.channelsIdle;
    }

    public long getChannelsMinimum() {
        return this.channelsMinimum;
    }

    public long getResourcesStatsCreated() {
        return this.resourcesStatsCreated;
    }

    public long getResourcesStatsDestroyed() {
        return this.resourcesStatsDestroyed;
    }

    public long getResourcesStatsReleased() {
        return this.resourcesStatsReleased;
    }

    @Override
    void populateAttributes(List<MetricAttribute> attributes) {
        super.populateAttributes(attributes);
        attributes.add(new MetricAttribute("channelsIdle", "the number of idle channels", Long.class));
        attributes.add(new MetricAttribute("channelsMinimum", "the minimum number of channels available", Long.class));
        attributes.add(new MetricAttribute("resourcesStatsReleased", "the total number of resources released since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("resourcesStatsDestroyed", "the total number of resources destroyed due to failures since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("resourcesStatsCreated", "the total number of resources created since the last statistics reset", Long.class));
    }

    @Override
    void populateAttributeValues(Map<String, Object> values) {
        super.populateAttributeValues(values);
        values.put("channelsIdle", this.getChannelsIdle());
        values.put("channelsMinimum", this.getChannelsMinimum());
        values.put("resourcesStatsReleased", this.getResourcesStatsReleased());
        values.put("resourcesStatsDestroyed", this.getResourcesStatsDestroyed());
        values.put("resourcesStatsCreated", this.getResourcesStatsCreated());
    }

    public void resourceCreated() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            ++this.resourcesStatsCreated;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void resourceDestroyed() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            ++this.resourcesStatsDestroyed;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void resourceReleased() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            ++this.resourcesStatsReleased;
        }
        finally {
            writeLock.unlock();
        }
    }
}

