/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

import java.util.concurrent.TimeUnit;

public class StopWatch {
    private final StopCallback stopCallback;
    private volatile long startTimeNanos;
    private volatile long endTimeNanos;

    public StopWatch() {
        this(null);
    }

    public StopWatch(StopCallback stopCallback) {
        this.stopCallback = stopCallback;
    }

    private long getDuration() {
        return this.endTimeNanos - this.startTimeNanos;
    }

    public long getDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.getDuration(), TimeUnit.NANOSECONDS);
    }

    public void start() {
        this.startTimeNanos = System.nanoTime();
    }

    public void stop() {
        this.endTimeNanos = System.nanoTime();
        if (this.stopCallback != null) {
            this.stopCallback.stopped(this);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.endTimeNanos > this.startTimeNanos) {
            builder.append(this.getDuration());
            builder.append("ns");
        } else if (this.startTimeNanos > 0L) {
            builder.append("started at ");
            builder.append(this.startTimeNanos);
        } else {
            builder.append("0");
        }
        return builder.toString();
    }

    public static interface StopCallback {
        public void stopped(StopWatch var1);
    }
}

