/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal.console;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.kohsuke.args4j.Argument;

public class ExportCmd
extends Command {
    private static final String FILE_EXT_EPF = ".epf";
    @Argument(index=0, required=true, usage="file to export to")
    File file;
    @Argument(index=1, required=false, usage="path to a preference node")
    String path;

    public ExportCmd() {
        super("<file> [<path>] - export preferences to file");
    }

    protected void doExecute() throws Exception {
        IPreferencesService preferencesService = EclipsePreferencesUtil.getPreferencesService();
        if (!StringUtils.endsWithIgnoreCase((String)this.file.getName(), (String)FILE_EXT_EPF)) {
            this.file = new File(this.file.getParentFile(), this.file.getName().concat(FILE_EXT_EPF));
        }
        IEclipsePreferences node = preferencesService.getRootNode();
        if (StringUtils.isNotBlank((String)this.path)) {
            node = (IEclipsePreferences)node.node(this.path);
        }
        FileOutputStream output = FileUtils.openOutputStream((File)this.file);
        try {
            preferencesService.exportPreferences(node, (OutputStream)output, null);
            this.printf("Successfully exported %s to %s.", new Object[]{node.absolutePath(), this.file.getAbsolutePath()});
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }
}

