/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.NodeInfo;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateConfig;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateListener;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperPinger;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperServerApplication;
import org.eclipse.gyrex.common.internal.applications.BaseApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperGateApplication
extends BaseApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperGateApplication.class);
    private ScheduledExecutorService executor;
    private volatile ZooKeeperGateConfig config;

    public static void reconnect() {
        ZooKeeperGateApplication gateApplication = ZooKeeperServerApplication.connectedGateApplication;
        if (gateApplication == null) {
            throw new IllegalStateException("The ZooKeeper gate manager application is not started!");
        }
        gateApplication.refreshConfig();
        ZooKeeperGate gate = ZooKeeperGate.getAndSet(null);
        if (gate != null) {
            gate.shutdown(true);
        }
    }

    public ZooKeeperGateApplication() {
        this.debug = CloudDebug.zooKeeperGateLifecycle;
    }

    protected void doCleanup() {
        ZooKeeperServerApplication.connectedGateApplication = null;
        if (this.executor != null) {
            try {
                this.executor.shutdownNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.executor = null;
        }
    }

    protected void doStart(Map arguments) throws Exception {
        this.refreshConfig();
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "ZooKeeper Gate Connect Thread");
                t.setDaemon(true);
                return t;
            }
        });
        this.scheduleConnect(this.executor, 1000);
        if (CloudActivator.getInstance().getNodeEnvironment().inStandaloneMode()) {
            ZooKeeperServerApplication.connectedGateApplication = this;
        }
        this.executor.scheduleWithFixedDelay(new ZooKeeperPinger(), 1L, 5L, TimeUnit.MINUTES);
    }

    protected Object doStop() {
        this.executor.shutdownNow();
        this.executor = null;
        ZooKeeperServerApplication.connectedGateApplication = null;
        ZooKeeperGate gate = ZooKeeperGate.getAndSet(null);
        if (gate != null) {
            gate.shutdown(true);
        }
        return EXIT_OK;
    }

    ZooKeeperGateConfig getConfig() {
        ZooKeeperGateConfig gateConfig = this.config;
        if (gateConfig == null) {
            throw new IllegalStateException("ZooKeeper gate configuration not initialized.");
        }
        return gateConfig;
    }

    protected Logger getLogger() {
        return LOG;
    }

    private void refreshConfig() {
        ZooKeeperGateConfig config = new ZooKeeperGateConfig(new NodeInfo());
        config.readFromPreferences();
        this.config = config;
    }

    void scheduleConnect(ScheduledExecutorService executor, int delay) {
        if (CloudDebug.zooKeeperGateLifecycle) {
            LOG.debug("Scheduling ZooKeeper connect attempt in {}s.", (Object)TimeUnit.MILLISECONDS.toSeconds(delay));
        }
        executor.schedule(new ConnectRunnable(executor, delay), (long)delay, TimeUnit.MILLISECONDS);
    }

    private final class ConnectRunnable
    implements Runnable,
    ZooKeeperGateListener {
        private static final int INITIAL_CONNECT_DELAY = 1000;
        private static final int MAX_CONNECT_DELAY = 300000;
        private final ScheduledExecutorService executor;
        private volatile int delay;

        private ConnectRunnable(ScheduledExecutorService executor, int delay) {
            this.executor = executor;
            this.delay = delay;
        }

        @Override
        public void gateDown(ZooKeeperGate gate) {
            ZooKeeperGate oldGate;
            if (CloudDebug.zooKeeperGateLifecycle) {
                LOG.debug("Processing disconnect event from gate.");
            }
            if ((oldGate = ZooKeeperGate.getAndSet(null)) != null) {
                oldGate.shutdown(false);
            }
            this.scheduleReconnectIfPossible();
        }

        @Override
        public void gateRecovering(ZooKeeperGate gate) {
        }

        @Override
        public void gateUp(ZooKeeperGate gate) {
            this.delay = 1000;
        }

        private int nextDelay() {
            return Math.min(300000, this.delay * 2);
        }

        @Override
        public void run() {
            if (CloudDebug.zooKeeperGateLifecycle) {
                LOG.debug("Connecting to ZooKeeper.");
            }
            ZooKeeperGate oldGate = null;
            try {
                try {
                    oldGate = ZooKeeperGate.getAndSet(new ZooKeeperGate(ZooKeeperGateApplication.this.getConfig(), this));
                    if (CloudDebug.zooKeeperGateLifecycle) {
                        LOG.debug("Successfully establish ZooKeeper connection. Gate is almost ready.");
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unable to establish ZooKeeper connection. Will retry later. {}", (Object)e.getMessage());
                    this.scheduleReconnectIfPossible();
                    if (oldGate != null) {
                        oldGate.shutdown(true);
                    }
                }
            }
            finally {
                if (oldGate != null) {
                    oldGate.shutdown(true);
                }
            }
        }

        private void scheduleReconnectIfPossible() {
            if (ZooKeeperGateApplication.this.isActive()) {
                if (CloudDebug.zooKeeperGateLifecycle) {
                    LOG.debug("Will re-connect because ZooKeeper Gate manager is still active.");
                }
                try {
                    ZooKeeperGateApplication.this.scheduleConnect(this.executor, this.nextDelay());
                }
                catch (RejectedExecutionException e) {
                    LOG.warn("Arborting ZooKeeper connect request. Gate manager is closed.");
                }
            }
        }
    }
}

