/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.cloud.services.queue.IMessage;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.manager.JobHungDetectionHelper;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.StorableBackedJobHistoryEntry;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferncesJobHistoryStorage;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferncesJobStorage;
import org.eclipse.gyrex.jobs.internal.util.ContextHashUtil;
import org.eclipse.gyrex.jobs.internal.worker.JobInfo;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.osgi.service.prefs.BackingStoreException;

public class LsCmd
extends Command {
    @Argument(index=0, usage="specify what to list (schedules, jobs or providers)", required=true, metaVar="WHAT")
    String what;
    @Argument(index=1, usage="an optional filter string", required=false, metaVar="FILTER")
    String searchString;
    @Option(name="-q", aliases={"--queue-id"}, usage="an optional queue id", required=false, metaVar="QUEUE-ID")
    String queueId = "gyrex.jobs.queue.default";

    private static String toRelativeTime(long duration) {
        if (duration < TimeUnit.MINUTES.toMillis(2L)) {
            return "a minute ago";
        }
        if (duration < TimeUnit.HOURS.toMillis(2L)) {
            return String.format("%d minutes ago", TimeUnit.MILLISECONDS.toMinutes(duration));
        }
        return String.format("%d hours ago", TimeUnit.MILLISECONDS.toMinutes(duration));
    }

    public LsCmd() {
        super("<schedules|providers|running|waiting|all|job|queue> [<filterString>] - lists schedules or jobs");
    }

    protected void doExecute() throws Exception {
        if (StringUtils.isBlank((String)this.what)) {
            this.printf("ERROR: please specify what to list", new Object[0]);
            return;
        }
        if (StringUtils.startsWithIgnoreCase((String)"providers", (String)this.what)) {
            this.printProviders();
        } else if (StringUtils.startsWithIgnoreCase((String)"schedules", (String)this.what)) {
            this.printSchedules();
        } else if (StringUtils.startsWithIgnoreCase((String)"running", (String)this.what)) {
            this.printJobs(JobState.RUNNING);
        } else if (StringUtils.startsWithIgnoreCase((String)"waiting", (String)this.what)) {
            this.printJobs(JobState.WAITING);
        } else if (StringUtils.startsWithIgnoreCase((String)"all", (String)this.what)) {
            this.printJobs(null);
        } else if (StringUtils.startsWithIgnoreCase((String)"job", (String)this.what)) {
            this.printJobs(null);
        } else if (StringUtils.startsWithIgnoreCase((String)"queues", (String)this.what)) {
            this.printJobsQueue();
        }
    }

    private String getActiveNodeId(String storageId) {
        try {
            return JobHungDetectionHelper.getProcessingNodeId(storageId, null);
        }
        catch (IllegalStateException e) {
            return String.format("[%s]", e.getMessage());
        }
    }

    private SortedSet<String> getJobIds(JobState state) throws BackingStoreException {
        String[] storageIds = CloudPreferncesJobStorage.getJobsNode().childrenNames();
        if (state == null) {
            return new TreeSet<String>(Arrays.asList(storageIds));
        }
        TreeSet<String> jobIds = new TreeSet<String>();
        String[] stringArray = storageIds;
        int n = storageIds.length;
        int n2 = 0;
        while (n2 < n) {
            String storageId = stringArray[n2];
            if (StringUtils.equals((String)CloudPreferncesJobStorage.getJobsNode().node(storageId).get("status", null), (String)state.name())) {
                jobIds.add(storageId);
            }
            ++n2;
        }
        return jobIds;
    }

    private void printJob(JobImpl job) throws Exception {
        StrBuilder info = new StrBuilder();
        info.appendln(job.getId());
        info.appendFixedWidthPadLeft((Object)"type: ", 26, ' ').appendln(job.getTypeId());
        info.appendFixedWidthPadLeft((Object)"state: ", 26, ' ').appendln((Object)job.getState());
        info.appendFixedWidthPadLeft((Object)"last start time: ", 26, ' ').appendln(job.getLastStart() > -1L ? DateFormatUtils.formatUTC((long)job.getLastStart(), (String)"yyyy-MM-dd 'at' HH:mm:ss z") : "never");
        info.appendFixedWidthPadLeft((Object)"last successfull finish: ", 26, ' ').appendln(job.getLastSuccessfulFinish() > -1L ? DateFormatUtils.formatUTC((long)job.getLastSuccessfulFinish(), (String)"yyyy-MM-dd 'at' HH:mm:ss z") : "never");
        info.appendFixedWidthPadLeft((Object)"last result: ", 26, ' ').appendln(job.getLastResult() != null ? job.getLastResult().getMessage() : "(not available)");
        String activeNodeId = this.getActiveNodeId(job.getStorageKey());
        info.appendFixedWidthPadLeft((Object)"active on: ", 26, ' ').appendln(activeNodeId != null ? activeNodeId : "(not active)");
        IEclipsePreferences historyNode = CloudPreferncesJobHistoryStorage.getJobsHistoryNode();
        if (historyNode.nodeExists(job.getStorageKey())) {
            IEclipsePreferences jobHistory = CloudPreferncesJobHistoryStorage.getHistoryNode(job.getStorageKey());
            String[] childrenNames = jobHistory.childrenNames();
            TreeSet<StorableBackedJobHistoryEntry> entries = new TreeSet<StorableBackedJobHistoryEntry>();
            String[] stringArray = childrenNames;
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                entries.add(new StorableBackedJobHistoryEntry(CloudPreferncesJobHistoryStorage.readItem(jobHistory.node(string))));
                ++n2;
            }
            info.appendNewLine();
            for (IJobHistoryEntry iJobHistoryEntry : entries) {
                info.appendln(iJobHistoryEntry.toString());
            }
        }
        this.printf("%s", new Object[]{info.toString()});
    }

    private void printJobs(JobState state) throws Exception {
        SortedSet<String> storageIds = this.getJobIds(state);
        if (StringUtils.isNotBlank((String)this.searchString) && IdHelper.isValidId((String)this.searchString)) {
            for (String storageId : storageIds) {
                JobImpl job;
                String externalId = ContextHashUtil.getExternalId(storageId);
                if (!StringUtils.equals((String)this.searchString, (String)externalId) || (job = CloudPreferncesJobStorage.readJob(externalId, CloudPreferncesJobStorage.getJobsNode().node(storageId))) == null) continue;
                this.printJob(job);
                return;
            }
        }
        boolean found = false;
        for (String storageId : storageIds) {
            String externalId = ContextHashUtil.getExternalId(storageId);
            if (!StringUtils.isBlank((String)this.searchString) && !StringUtils.contains((String)storageId, (String)this.searchString)) continue;
            String activeNodeId = this.getActiveNodeId(storageId);
            if (activeNodeId != null) {
                this.printf("%s (active on %s, %s)", new Object[]{externalId, activeNodeId, storageId});
            } else {
                this.printf("%s (%s)", new Object[]{externalId, storageId});
            }
            found = true;
        }
        if (!found) {
            if (state != null) {
                this.printf("no %s jobs found", new Object[]{state.name()});
            } else {
                this.printf("no jobs found", new Object[0]);
            }
            return;
        }
    }

    private void printJobsQueue() {
        if (!IdHelper.isValidId((String)this.queueId)) {
            this.printf("ERROR: invalid queueId: %s", new Object[]{this.queueId});
            return;
        }
        IQueue queue = JobsActivator.getInstance().getQueueService().getQueue(this.queueId, null);
        if (queue == null) {
            this.printf("ERROR: queue not found: %s", new Object[]{this.queueId});
            return;
        }
        HashMap<String, Long> properties = new HashMap<String, Long>(2);
        properties.put("queue.message.receive.timeout", new Long(0L));
        List message = queue.receiveMessages(500, properties);
        if (message.isEmpty()) {
            this.printf("Queue '%s' is empty!", new Object[]{this.queueId});
            return;
        }
        this.printf("Found %d messages:", new Object[]{message.size()});
        for (IMessage m : message) {
            try {
                JobInfo jobInfo = JobInfo.parse(m);
                if (this.searchString != null && !StringUtils.containsIgnoreCase((String)jobInfo.getJobId(), (String)this.searchString) && !StringUtils.containsIgnoreCase((String)jobInfo.getContextPath().toString(), (String)this.searchString)) continue;
                this.printf("  %s (%s, %s, %s)", new Object[]{jobInfo.getJobId(), jobInfo.getContextPath(), LsCmd.toRelativeTime(System.currentTimeMillis() - jobInfo.getQueueTimestamp()), jobInfo.getQueueTrigger()});
            }
            catch (IOException e) {
                this.printf("  %s", new Object[]{e.getMessage()});
            }
        }
    }

    private void printProviders() {
        TreeSet<String> providers = new TreeSet<String>(JobsActivator.getInstance().getJobProviderRegistry().getProviders());
        for (String id : providers) {
            if (!StringUtils.isBlank((String)this.searchString) && !StringUtils.contains((String)id, (String)this.searchString)) continue;
            this.printf(id, new Object[0]);
        }
    }

    private void printSchedule(ISchedule schedule) {
        StrBuilder info = new StrBuilder();
        info.append(schedule.getId());
        if (!schedule.isEnabled()) {
            info.appendln(" DISABLED");
        }
        TimeZone timeZone = schedule.getTimeZone();
        info.append("  time zone: ").append(timeZone.getDisplayName(false, 1, Locale.US)).appendln(timeZone.useDaylightTime() ? " (will adjust to daylight changes)" : " (independent of daylight changes)");
        info.append("      queue: ").appendln(schedule.getQueueId() != null ? schedule.getQueueId() : "(default)");
        String prefix = "    entries: ";
        List<IScheduleEntry> entries = schedule.getEntries();
        if (!entries.isEmpty()) {
            for (IScheduleEntry entry : entries) {
                info.append(prefix).append(entry.getId()).append(' ').append(entry.getCronExpression()).append(' ').append(entry.getJobTypeId()).appendNewLine();
                prefix = "             ";
                Map<String, String> parameter = entry.getJobParameter();
                if (parameter.isEmpty()) continue;
                Set<Map.Entry<String, String>> entrySet = parameter.entrySet();
                for (Map.Entry<String, String> param : entrySet) {
                    info.append(prefix).append("    ").append(param.getKey()).append('=').appendln(param.getValue());
                }
            }
        } else {
            info.append(prefix).appendln("(none)");
        }
        this.printf("%s", new Object[]{info.toString()});
    }

    private void printSchedules() throws Exception {
        TreeSet<String> storageIds = new TreeSet<String>(Arrays.asList(ScheduleStore.getSchedules()));
        if (StringUtils.isNotBlank((String)this.searchString)) {
            for (String storageId : storageIds) {
                ScheduleImpl schedule;
                String externalId = ScheduleManagerImpl.getExternalId(storageId);
                if (!StringUtils.equals((String)this.searchString, (String)externalId) || (schedule = ScheduleStore.load(storageId, externalId, false)) == null) continue;
                this.printSchedule(schedule);
                return;
            }
        }
        boolean found = false;
        for (String storageId : storageIds) {
            String externalId = ScheduleManagerImpl.getExternalId(storageId);
            if (!StringUtils.isBlank((String)this.searchString) && !StringUtils.contains((String)storageId, (String)this.searchString)) continue;
            this.printf("%s (storage key %s)", new Object[]{externalId, storageId});
            found = true;
        }
        if (!found) {
            this.printf("No schedules found!", new Object[0]);
        }
    }
}

