/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.SynStreamFrame;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;
import org.eclipse.jetty.spdy.generator.HeadersBlockGenerator;
import org.eclipse.jetty.util.BufferUtil;

public class SynStreamGenerator
extends ControlFrameGenerator {
    private final HeadersBlockGenerator headersBlockGenerator;

    public SynStreamGenerator(ByteBufferPool bufferPool, HeadersBlockGenerator headersBlockGenerator) {
        super(bufferPool);
        this.headersBlockGenerator = headersBlockGenerator;
    }

    @Override
    public ByteBuffer generate(ControlFrame frame) {
        int frameBodyLength = 10;
        SynStreamFrame synStream = (SynStreamFrame)frame;
        short version = synStream.getVersion();
        ByteBuffer headersBuffer = this.headersBlockGenerator.generate(version, synStream.getHeaders());
        int frameLength = frameBodyLength + headersBuffer.remaining();
        if (frameLength > 0xFFFFFF) {
            throw new SessionException(SessionStatus.PROTOCOL_ERROR, "Too many headers");
        }
        int totalLength = 8 + frameLength;
        ByteBuffer buffer = this.getByteBufferPool().acquire(totalLength, true);
        BufferUtil.clearToFill((ByteBuffer)buffer);
        this.generateControlFrameHeader(synStream, frameLength, buffer);
        int streamId = synStream.getStreamId();
        buffer.putInt(streamId & Integer.MAX_VALUE);
        buffer.putInt(synStream.getAssociatedStreamId() & Integer.MAX_VALUE);
        this.writePriority(streamId, version, synStream.getPriority(), buffer);
        buffer.put((byte)synStream.getSlot());
        buffer.put(headersBuffer);
        buffer.flip();
        return buffer;
    }

    private void writePriority(int streamId, short version, byte priority, ByteBuffer buffer) {
        switch (version) {
            case 2: {
                priority = (byte)(priority << 6);
                break;
            }
            case 3: {
                priority = (byte)(priority << 5);
                break;
            }
            default: {
                throw new StreamException(streamId, StreamStatus.UNSUPPORTED_VERSION);
            }
        }
        buffer.put(priority);
    }
}

