/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal.generic;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.gyrex.admin.ui.jobs.configuration.wizard.JobConfigurationWizardSession;
import org.eclipse.gyrex.admin.ui.jobs.internal.generic.AddEditParameterDialog;
import org.eclipse.gyrex.admin.ui.jobs.internal.generic.Parameter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GenericJobParameterPage
extends WizardPage {
    private static final long serialVersionUID = 1L;
    final ListDialogField parameterTable = new ListDialogField(new IListAdapter(){

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    GenericJobParameterPage.this.openAddParameterDialog();
                    break;
                }
                case 1: {
                    GenericJobParameterPage.this.openEditParameterDialog();
                    break;
                }
            }
        }

        public void doubleClicked(ListDialogField field) {
            GenericJobParameterPage.this.openEditParameterDialog();
        }

        public void selectionChanged(ListDialogField field) {
            field.enableButton(2, field.getSelectedElements().size() == 1);
        }
    }, new String[]{"New...", "Edit...", "Remove"}, (ILabelProvider)new ColumnLabelProvider(){
        private static final long serialVersionUID = 1L;

        public String getText(Object element) {
            if (element instanceof Parameter) {
                return ((Parameter)element).getName();
            }
            return element == null ? "" : element.toString();
        }

        public void update(ViewerCell cell) {
            Parameter element = (Parameter)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(element.getName());
                    break;
                }
                case 1: {
                    cell.setText(element.getValue());
                    break;
                }
            }
        }
    });
    private final JobConfigurationWizardSession session;

    public GenericJobParameterPage(JobConfigurationWizardSession session) {
        super(GenericJobParameterPage.class.getSimpleName());
        this.parameterTable.setRemoveButtonIndex(2);
        this.parameterTable.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"Parameter", "Value"}, true));
        this.session = session;
        this.setTitle("Task Parameter");
        this.setDescription("Configure the task by modifying its launch parameter.");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(this.convertVerticalDLUsToPixels(200), this.convertHorizontalDLUsToPixels(400)).create());
        this.setControl((Control)composite);
        this.parameterTable.setLabelText(String.format("Parameter for %s:", this.session.getJobTypeName()));
        this.parameterTable.setViewerComparator(new ViewerComparator());
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                GenericJobParameterPage.this.validate();
            }
        };
        this.parameterTable.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.parameterTable}, (boolean)true);
        LayoutUtil.setHorizontalGrabbing((Control)this.parameterTable.getListControl(null));
        this.readParameterFromSession();
    }

    void openAddParameterDialog() {
        final AddEditParameterDialog dialog = new AddEditParameterDialog(this.getShell(), null, this.parameterTable.getElements());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0 && StringUtils.isNotBlank((String)dialog.getName())) {
                    GenericJobParameterPage.this.parameterTable.addElement((Object)new Parameter(dialog.getName(), dialog.getValue()));
                }
            }
        });
    }

    void openEditParameterDialog() {
        final Parameter v = (Parameter)this.parameterTable.getSelectedElements().iterator().next();
        final AddEditParameterDialog dialog = new AddEditParameterDialog(this.getShell(), v, this.parameterTable.getElements());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0 && StringUtils.isNotBlank((String)dialog.getName())) {
                    v.setName(dialog.getName());
                    v.setValue(dialog.getValue());
                    GenericJobParameterPage.this.parameterTable.refresh();
                }
            }
        });
    }

    private void readParameterFromSession() {
        this.parameterTable.removeAllElements();
        for (Map.Entry<String, String> e : this.session.getParameter().entrySet()) {
            this.parameterTable.addElement((Object)new Parameter(e.getKey(), e.getValue()));
        }
        this.parameterTable.selectElements(null);
    }

    private void saveParameterToSession() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Object variable : this.parameterTable.getElements()) {
            Parameter v = (Parameter)variable;
            result.put(v.getName(), v.getValue());
        }
        this.session.setParameter(result);
    }

    void validate() {
        this.saveParameterToSession();
        this.setMessage(null);
        this.setPageComplete(true);
    }
}

