/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.internal;

import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.model.ConsoleAppender;
import org.eclipse.gyrex.logback.config.model.FileAppender;
import org.eclipse.gyrex.logback.config.spi.AppenderProvider;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CommonLogbackAppenders
extends AppenderProvider {
    private static final String FILE = "file";
    private static final String CONSOLE = "console";
    private static final String PATTERN = "pattern";
    private static final String ROTATION_POLICY = "rotationPolicy";
    private static final String SIFTING_MDC_PROPERTYDEFAULT_VALUE = "siftingMdcPropertydefaultValue";
    private static final String SIFTING_MDC_PROPERTY_NAME = "siftingMdcPropertyName";
    private static final String COMPRESS_ROTATED_LOGS = "compressRotatedLogs";
    private static final String MAX_FILE_SIZE = "maxFileSize";
    private static final String MAX_HISTORY = "maxHistory";
    private static final String FILE_NAME = "fileName";

    public CommonLogbackAppenders() {
        super(CONSOLE, FILE);
    }

    @Override
    public Appender createAppender(String typeId) throws Exception {
        switch (typeId) {
            case "console": {
                return new ConsoleAppender();
            }
            case "file": {
                return new FileAppender();
            }
        }
        return null;
    }

    @Override
    public String getName(String typeId) {
        switch (typeId) {
            case "console": {
                return "Console";
            }
            case "file": {
                return "File";
            }
        }
        return null;
    }

    @Override
    public Appender loadAppender(String typeId, Preferences node) throws Exception {
        switch (typeId) {
            case "console": {
                return this.loadConsoleAppender(node);
            }
            case "file": {
                return this.loadFileAppender(node);
            }
        }
        return null;
    }

    private Appender loadConsoleAppender(Preferences node) throws BackingStoreException {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName(node.name());
        appender.setPattern(node.get(PATTERN, null));
        return appender;
    }

    private Appender loadFileAppender(Preferences node) throws BackingStoreException {
        FileAppender fileAppender = new FileAppender();
        fileAppender.setName(node.name());
        fileAppender.setPattern(node.get(PATTERN, null));
        fileAppender.setFileName(node.get(FILE_NAME, null));
        try {
            fileAppender.setRotationPolicy(FileAppender.RotationPolicy.valueOf(node.get(ROTATION_POLICY, null)));
            fileAppender.setMaxHistory(node.get(MAX_HISTORY, null));
            fileAppender.setMaxFileSize(node.get(MAX_FILE_SIZE, null));
            if (node.get(COMPRESS_ROTATED_LOGS, null) != null) {
                fileAppender.setCompressRotatedLogs(node.getBoolean(COMPRESS_ROTATED_LOGS, true));
            }
        }
        catch (IllegalArgumentException e) {
            fileAppender.setRotationPolicy(null);
        }
        if (node.get(SIFTING_MDC_PROPERTY_NAME, null) != null) {
            fileAppender.setSiftingMdcPropertyName(node.get(SIFTING_MDC_PROPERTY_NAME, null));
            if (node.get(SIFTING_MDC_PROPERTYDEFAULT_VALUE, null) != null) {
                fileAppender.setSiftingMdcPropertyDefaultValue(node.get(SIFTING_MDC_PROPERTYDEFAULT_VALUE, null));
            }
        }
        return fileAppender;
    }

    private void saveConsoleAppender(ConsoleAppender appender, Preferences node) {
        if (appender.getPattern() != null) {
            node.put(PATTERN, appender.getPattern());
        } else {
            node.remove(PATTERN);
        }
    }

    private void saveFileAppender(FileAppender appender, Preferences node) {
        if (appender.getPattern() != null) {
            node.put(PATTERN, appender.getPattern());
        } else {
            node.remove(PATTERN);
        }
        if (appender.getFileName() != null) {
            node.put(FILE_NAME, appender.getFileName());
        } else {
            node.remove(FILE_NAME);
        }
        if (appender.getRotationPolicy() != null) {
            node.put(ROTATION_POLICY, appender.getRotationPolicy().name());
        } else {
            node.remove(ROTATION_POLICY);
        }
        if (appender.getMaxHistory() != null) {
            node.put(MAX_HISTORY, appender.getMaxHistory());
        } else {
            node.remove(MAX_HISTORY);
        }
        if (appender.getMaxFileSize() != null) {
            node.put(MAX_FILE_SIZE, appender.getMaxFileSize());
        } else {
            node.remove(MAX_FILE_SIZE);
        }
        if (appender.isSeparateLogOutputsPerMdcProperty()) {
            node.put(SIFTING_MDC_PROPERTY_NAME, appender.getSiftingMdcPropertyName());
            node.put(SIFTING_MDC_PROPERTYDEFAULT_VALUE, StringUtils.trimToEmpty((String)appender.getSiftingMdcPropertyDefaultValue()));
        } else {
            node.remove(SIFTING_MDC_PROPERTY_NAME);
            node.remove(SIFTING_MDC_PROPERTYDEFAULT_VALUE);
        }
        if (!appender.isCompressRotatedLogs()) {
            node.putBoolean(COMPRESS_ROTATED_LOGS, false);
        } else {
            node.remove(COMPRESS_ROTATED_LOGS);
        }
    }

    @Override
    public void writeAppender(Appender appender, Preferences node) throws Exception {
        if (appender instanceof ConsoleAppender) {
            this.saveConsoleAppender((ConsoleAppender)appender, node);
        } else if (appender instanceof FileAppender) {
            this.saveFileAppender((FileAppender)appender, node);
        }
    }
}

