/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpSender
implements AsyncContentProvider.Listener {
    private static final Logger LOG = Log.getLogger(HttpSender.class);
    private static final String EXPECT_100_ATTRIBUTE = HttpSender.class.getName() + ".expect100";
    private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
    private final AtomicReference<SendState> sendState = new AtomicReference<SendState>(SendState.IDLE);
    private final HttpGenerator generator = new HttpGenerator();
    private final HttpConnection connection;
    private Iterator<ByteBuffer> contentIterator;
    private ContinueContentChunk continueContentChunk;

    public HttpSender(HttpConnection connection) {
        this.connection = connection;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onContent() {
        block5: while (true) {
            current = this.sendState.get();
            switch (2.$SwitchMap$org$eclipse$jetty$client$HttpSender$SendState[current.ordinal()]) {
                case 1: {
                    if (!this.updateSendState(current, SendState.EXECUTE)) continue block5;
                    HttpSender.LOG.debug("Deferred content available, sending", new Object[0]);
                    this.send();
                    return;
                }
                case 2: {
                    if (this.updateSendState(current, SendState.SCHEDULE)) ** break;
                    continue block5;
                    HttpSender.LOG.debug("Deferred content available, scheduling", new Object[0]);
                    return;
                }
                case 3: {
                    HttpSender.LOG.debug("Deferred content available, queueing", new Object[0]);
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public void send(HttpExchange exchange) {
        if (!this.updateState(State.IDLE, State.BEGIN)) {
            throw new IllegalStateException();
        }
        Request request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            exchange.abort(cause);
        } else {
            LOG.debug("Sending {}", new Object[]{request});
            RequestNotifier notifier = this.connection.getDestination().getRequestNotifier();
            notifier.notifyBegin(request);
            ContentProvider content = request.getContent();
            this.contentIterator = content == null ? Collections.emptyIterator() : content.iterator();
            boolean updated = this.updateSendState(SendState.IDLE, SendState.EXECUTE);
            assert (updated);
            if (content instanceof AsyncContentProvider) {
                ((AsyncContentProvider)content).setListener(this);
            }
            this.send();
        }
    }

    /*
     * Exception decompiling
     */
    private void send() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean processWrite(Request request, ByteBuffer content, boolean expecting100ContinueResponse) {
        if (!this.commit(request)) {
            return false;
        }
        if (content != null) {
            RequestNotifier notifier = this.connection.getDestination().getRequestNotifier();
            notifier.notifyContent(request, content);
        }
        if (expecting100ContinueResponse) {
            LOG.debug("Expecting 100 Continue for {}", new Object[]{request});
            this.continueContentChunk.signal();
            return false;
        }
        return true;
    }

    public void proceed(boolean proceed) {
        ContinueContentChunk contentChunk = this.continueContentChunk;
        if (contentChunk != null) {
            if (proceed) {
                LOG.debug("Proceeding {}", new Object[]{this.connection.getExchange()});
                contentChunk.await();
                this.send();
            } else {
                HttpExchange exchange = this.connection.getExchange();
                if (exchange != null) {
                    this.fail(new HttpRequestException("Expectation failed", exchange.getRequest()));
                }
            }
        }
    }

    private void write(Callback callback, ByteBuffer header, ByteBuffer chunk, ByteBuffer content) {
        int mask = 0;
        if (header != null) {
            ++mask;
        }
        if (chunk != null) {
            mask += 2;
        }
        if (content != null) {
            mask += 4;
        }
        EndPoint endPoint = this.connection.getEndPoint();
        switch (mask) {
            case 0: {
                endPoint.write(callback, new ByteBuffer[]{BufferUtil.EMPTY_BUFFER});
                break;
            }
            case 1: {
                endPoint.write(callback, new ByteBuffer[]{header});
                break;
            }
            case 2: {
                endPoint.write(callback, new ByteBuffer[]{chunk});
                break;
            }
            case 3: {
                endPoint.write(callback, new ByteBuffer[]{header, chunk});
                break;
            }
            case 4: {
                endPoint.write(callback, new ByteBuffer[]{content});
                break;
            }
            case 5: {
                endPoint.write(callback, new ByteBuffer[]{header, content});
                break;
            }
            case 6: {
                endPoint.write(callback, new ByteBuffer[]{chunk, content});
                break;
            }
            case 7: {
                endPoint.write(callback, new ByteBuffer[]{header, chunk, content});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    protected boolean commit(Request request) {
        block5: while (true) {
            State current = this.state.get();
            switch (current) {
                case HEADERS: {
                    if (!this.updateState(current, State.COMMIT)) continue block5;
                    LOG.debug("Committed {}", new Object[]{request});
                    RequestNotifier notifier = this.connection.getDestination().getRequestNotifier();
                    notifier.notifyCommit(request);
                    return true;
                }
                case COMMIT: {
                    if (this.updateState(current, State.COMMIT)) return true;
                    continue block5;
                }
                case FAILURE: {
                    return false;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    protected boolean success() {
        HttpExchange exchange = this.connection.getExchange();
        if (exchange == null) {
            return false;
        }
        AtomicMarkableReference<Result> completion = exchange.requestComplete(null);
        if (!completion.isMarked()) {
            return false;
        }
        this.generator.reset();
        if (!this.updateState(State.COMMIT, State.IDLE)) {
            throw new IllegalStateException();
        }
        exchange.terminateRequest();
        HttpDestination destination = this.connection.getDestination();
        Request request = exchange.getRequest();
        destination.getRequestNotifier().notifySuccess(request);
        LOG.debug("Sent {}", new Object[]{request});
        Result result = completion.getReference();
        if (result != null) {
            this.connection.complete(exchange, !result.isFailed());
            HttpConversation conversation = exchange.getConversation();
            destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
        }
        return true;
    }

    protected boolean fail(Throwable failure) {
        State current;
        HttpExchange exchange = this.connection.getExchange();
        if (exchange == null) {
            return false;
        }
        AtomicMarkableReference<Result> completion = exchange.requestComplete(failure);
        if (!completion.isMarked()) {
            return false;
        }
        this.generator.abort();
        while (!this.updateState(current = this.state.get(), State.FAILURE)) {
        }
        this.shutdownOutput();
        exchange.terminateRequest();
        HttpDestination destination = this.connection.getDestination();
        Request request = exchange.getRequest();
        destination.getRequestNotifier().notifyFailure(request, failure);
        LOG.debug("Failed {} {}", new Object[]{request, failure});
        Result result = completion.getReference();
        boolean notCommitted = this.isBeforeCommit(current);
        if (result == null && notCommitted && request.getAbortCause() == null) {
            result = exchange.responseComplete(failure).getReference();
            exchange.terminateResponse();
            LOG.debug("Failed on behalf {}", new Object[]{exchange});
        }
        if (result != null) {
            this.connection.complete(exchange, false);
            HttpConversation conversation = exchange.getConversation();
            destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
        }
        return true;
    }

    private void shutdownOutput() {
        this.connection.getEndPoint().shutdownOutput();
    }

    public boolean abort(Throwable cause) {
        State current = this.state.get();
        boolean abortable = this.isBeforeCommit(current) || current == State.COMMIT && this.contentIterator.hasNext();
        return abortable && this.fail(cause);
    }

    private boolean isBeforeCommit(State state) {
        return state == State.IDLE || state == State.BEGIN || state == State.HEADERS;
    }

    private void releaseBuffers(ByteBufferPool bufferPool, ByteBuffer header, ByteBuffer chunk) {
        if (!BufferUtil.hasContent((ByteBuffer)header)) {
            bufferPool.release(header);
        }
        if (!BufferUtil.hasContent((ByteBuffer)chunk)) {
            bufferPool.release(chunk);
        }
    }

    private boolean updateState(State from, State to) {
        boolean updated = this.state.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{from, to, this.state.get()});
        }
        return updated;
    }

    private boolean updateSendState(SendState from, SendState to) {
        boolean updated = this.sendState.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("Send state update failed: {} -> {}: {}", new Object[]{from, to, this.sendState.get()});
        }
        return updated;
    }

    private class ContinueContentChunk
    extends ContentChunk {
        private final CountDownLatch latch;

        private ContinueContentChunk(ContentChunk chunk) {
            super(chunk);
            this.latch = new CountDownLatch(1);
        }

        private void signal() {
            this.latch.countDown();
        }

        private void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException x) {
                LOG.ignore((Throwable)x);
            }
        }
    }

    private class ContentChunk {
        private final boolean lastContent;
        private final ByteBuffer content;

        private ContentChunk(ContentChunk chunk) {
            this.lastContent = chunk.lastContent;
            this.content = chunk.content;
        }

        private ContentChunk(Iterator<ByteBuffer> contentIterator) {
            this.lastContent = !contentIterator.hasNext();
            this.content = this.lastContent ? BufferUtil.EMPTY_BUFFER : contentIterator.next();
        }

        private boolean isDeferred() {
            return this.content == null && !this.lastContent;
        }

        static /* synthetic */ ByteBuffer access$100(ContentChunk x0) {
            return x0.content;
        }

        static /* synthetic */ boolean access$200(ContentChunk x0) {
            return x0.lastContent;
        }

        static /* synthetic */ boolean access$800(ContentChunk x0) {
            return x0.isDeferred();
        }
    }

    private static abstract class StatefulExecutorCallback
    implements Callback,
    Runnable {
        private final AtomicReference<State> state = new AtomicReference<State>(State.INCOMPLETE);
        private final Executor executor;

        private StatefulExecutorCallback(Executor executor) {
            this.executor = executor;
        }

        public final void succeeded() {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.SUCCEEDED)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(this);
            }
        }

        @Override
        public final void run() {
            this.onSucceeded();
        }

        protected abstract void onSucceeded();

        public final void failed(final Throwable x) {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.FAILED)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        StatefulExecutorCallback.this.onFailed(x);
                    }
                });
            } else {
                this.onFailed(x);
            }
        }

        protected abstract void onFailed(Throwable var1);

        public boolean process() {
            return this.state.compareAndSet(State.INCOMPLETE, State.PENDING);
        }

        public boolean isSucceeded() {
            return this.state.get() == State.SUCCEEDED;
        }

        public boolean isFailed() {
            return this.state.get() == State.FAILED;
        }

        private static enum State {
            INCOMPLETE,
            PENDING,
            SUCCEEDED,
            FAILED;

        }
    }

    private static enum SendState {
        IDLE,
        EXECUTE,
        SCHEDULE;

    }

    private static enum State {
        IDLE,
        BEGIN,
        HEADERS,
        COMMIT,
        FAILURE;

    }
}

