/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jaxrs.internal;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.wadl.config.WadlGeneratorConfig;
import com.sun.jersey.server.wadl.generators.WadlGeneratorJAXBGrammarGenerator;
import java.util.Set;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.context.IApplicationContext;
import org.eclipse.gyrex.http.jaxrs.internal.JaxRsDebug;
import org.eclipse.gyrex.http.jaxrs.internal.WadlResource;
import org.eclipse.gyrex.http.jaxrs.jersey.spi.inject.ContextApplicationContextInjectableProvider;
import org.eclipse.gyrex.http.jaxrs.jersey.spi.inject.ContextRuntimeContextInjectableProvider;
import org.eclipse.gyrex.http.jaxrs.jersey.spi.inject.InjectApplicationContextInjectableProvider;
import org.eclipse.gyrex.http.jaxrs.jersey.spi.inject.InjectRuntimeContextInjectableProvider;
import org.eclipse.gyrex.server.Platform;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRsExtensions {
    private static final Logger LOG = LoggerFactory.getLogger(JaxRsExtensions.class);

    public static void addCommonInjectors(Set<Object> singletons, IRuntimeContext context, IApplicationContext applicationContext) {
        singletons.add((Object)new ContextRuntimeContextInjectableProvider(context));
        singletons.add((Object)new ContextApplicationContextInjectableProvider(applicationContext));
        singletons.add((Object)new InjectRuntimeContextInjectableProvider(context));
        singletons.add((Object)new InjectApplicationContextInjectableProvider(applicationContext));
    }

    public static void addJsonProviderIfPossible(Set<Object> singletons) {
        Object jsonProvider = JaxRsExtensions.createMoxyJsonProvider();
        if (jsonProvider != null) {
            singletons.add(jsonProvider);
        }
    }

    public static void addWadlSupport(ResourceConfig resourceConfig) {
        resourceConfig.getSingletons().add(WadlGeneratorConfig.generator(WadlGeneratorJAXBGrammarGenerator.class).build());
        resourceConfig.getClasses().add(WadlResource.class);
    }

    private static Object createMoxyJsonProvider() {
        try {
            Class<?> providerClass = JaxRsExtensions.class.getClassLoader().loadClass("org.eclipse.persistence.jaxb.rs.MOXyJsonProvider");
            Object moxyJsonProvider = providerClass.newInstance();
            if (JaxRsDebug.debug || Platform.inDevelopmentMode()) {
                try {
                    providerClass.getMethod("setFormattedOutput", Boolean.TYPE).invoke(moxyJsonProvider, Boolean.TRUE);
                }
                catch (Exception e) {
                    LOG.warn("Unable to configure formatted output for MOXy JSON Provider. Please update the JAX-RS application bundle to an implementation which is compatible with the EclipseLink MOXy implementation in use ({}).", (Object)FrameworkUtil.getBundle(providerClass), (Object)e);
                }
            }
            return moxyJsonProvider;
        }
        catch (Exception e) {
            if (JaxRsDebug.debug) {
                LOG.debug("Unable to load MOXy JSON Provider. Please make sure MOXy is properly installed and resolved in order to use it.", (Throwable)e);
            }
            return null;
        }
    }

    private JaxRsExtensions() {
    }
}

