/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.jobs.internal.ContextPathProposals;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiActivator;
import org.eclipse.gyrex.admin.ui.jobs.internal.TimeZoneProposals;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleManager;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleWorkingCopy;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddScheduleDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private final StringDialogField idField = new StringDialogField();
    private final StringDialogField contextField = new StringDialogField();
    private final StringDialogField timeZoneField = new StringDialogField();

    public AddScheduleDialog(Shell parent) {
        super(parent);
        this.setTitle("New Schedule");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.idField.setLabelText("Id");
        this.contextField.setLabelText("Context Path");
        this.timeZoneField.setLabelText("TimeZone");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddScheduleDialog.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.contextField.setDialogFieldListener(validateListener);
        this.contextField.setContentProposalProcessor((IContentProposalProvider)new ContextPathProposals());
        this.timeZoneField.setContentProposalProcessor((IContentProposalProvider)new TimeZoneProposals());
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, this.contextField, this.timeZoneField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.contextField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.timeZoneField.getTextControl(null));
        LayoutUtil.setMargin((Composite)composite, (int)5);
        return composite;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            String contextPath = this.contextField.getText();
            IRuntimeContext context = ((IRuntimeContextRegistry)JobsUiActivator.getInstance().getService(IRuntimeContextRegistry.class)).get(new Path(contextPath).makeAbsolute().addTrailingSeparator());
            if (context != null) {
                IScheduleManager scheduleManager = (IScheduleManager)context.get(IScheduleManager.class);
                IScheduleWorkingCopy schedule = scheduleManager.createSchedule(this.idField.getText());
                if (StringUtils.isNotBlank((String)this.timeZoneField.getText())) {
                    schedule.setTimeZone(TimeZone.getTimeZone(this.timeZoneField.getText()));
                }
                scheduleManager.updateSchedule(schedule);
            } else {
                this.setError("Entered context path is not valid!");
            }
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.jobs", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.jobs", message));
    }

    void validate() {
        String id = this.idField.getText();
        if (StringUtils.isNotBlank((String)id) && !IdHelper.isValidId((String)id)) {
            this.setError("The entered schedule id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        String context = this.contextField.getText();
        if (StringUtils.isNotBlank((String)context)) {
            try {
                new URI(context);
            }
            catch (URISyntaxException e) {
                this.setError("The entered URL. Please use valid URI syntax. " + e.getMessage());
                return;
            }
        }
        String timeZone = this.timeZoneField.getText();
        StringUtils.isNotBlank((String)timeZone);
        if (StringUtils.isBlank((String)id)) {
            this.setInfo("Please enter a schedule id.");
            return;
        }
        if (StringUtils.isBlank((String)context)) {
            this.setInfo("Please enter a context path.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

