/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DescriptionDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExclusiveLockWizardPage
extends WizardPage {
    private static final long serialVersionUID = 1L;
    private final SelectionButtonDialogField requireLockCheckBox = new SelectionButtonDialogField(32);
    private final StringDialogField lockNameField = new StringDialogField();
    private final DescriptionDialogField lockDescriptionField = new DescriptionDialogField();
    private final ScheduleImpl schedule;
    private final ScheduleEntryImpl entry;

    public ExclusiveLockWizardPage(ScheduleImpl schedule, ScheduleEntryImpl entry) {
        super(ExclusiveLockWizardPage.class.getSimpleName());
        this.setTitle("Exclusive Lock");
        this.setDescription("Configure an exclusive lock for the job execution.");
        this.setPageComplete(false);
        this.schedule = schedule;
        this.entry = entry;
    }

    public void createControl(Composite parent) {
        String lockId;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(this.convertVerticalDLUsToPixels(200), this.convertHorizontalDLUsToPixels(400)).create());
        this.setControl((Control)composite);
        this.requireLockCheckBox.setLabelText("Require an exclusive lock before starting the task:");
        this.lockNameField.setLabelText("Lock Id:");
        this.lockDescriptionField.setText("<small>The lock will be acquired before the task is started. If the lock is already acquired elsewhere the task will be discarded. This allows to prevent different tasks from running in parallel.</small>");
        this.requireLockCheckBox.setAttachedDialogFields(new DialogField[]{this.lockNameField, this.lockDescriptionField});
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ExclusiveLockWizardPage.this.validate();
            }
        };
        this.lockNameField.setDialogFieldListener(validateListener);
        this.requireLockCheckBox.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.requireLockCheckBox, this.lockNameField, this.lockDescriptionField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.lockNameField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.lockDescriptionField.getDescriptionControl(null));
        LayoutUtil.setWidthHint((Control)this.lockDescriptionField.getDescriptionControl(null), (int)this.convertWidthInCharsToPixels(40));
        if (this.getEntry() != null && StringUtils.isNotBlank((String)(lockId = (String)this.getEntry().getJobParameter().get("gyrex.jobs.lockId")))) {
            this.requireLockCheckBox.setSelection(true);
            this.lockNameField.setText(lockId);
        }
    }

    public ScheduleEntryImpl getEntry() {
        return this.entry;
    }

    public String getLockId() {
        if (this.requireLockCheckBox.isSelected()) {
            return this.lockNameField.getText();
        }
        return null;
    }

    public ScheduleImpl getSchedule() {
        return this.schedule;
    }

    void validate() {
        String id = this.getLockId();
        if (StringUtils.isNotBlank((String)id) && !IdHelper.isValidId((String)id)) {
            this.setMessage("The entered lock id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.", 3);
            this.setPageComplete(false);
            return;
        }
        if (StringUtils.isBlank((String)id) && this.requireLockCheckBox.isSelected()) {
            this.setMessage("Please enter an lock identifier.", 1);
            this.setPageComplete(false);
            return;
        }
        this.setMessage(null);
        this.setPageComplete(true);
    }
}

