/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.console;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.console.SubCommand;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

class CommandUtil {
    static void appendCommandDescription(StrBuilder help, String name, Command command, String ident) {
        help.append(ident).append(name);
        String description = command.getDescription();
        if (!StringUtils.contains((String)description, (String)" - ")) {
            help.append(" - ");
        } else if (!StringUtils.startsWith((String)description, (String)" ")) {
            help.append(' ');
        }
        help.appendln(description);
    }

    static void appendCommandInfo(StrBuilder help, String commandName, Map<String, Class<? extends Command>> commands, String ident) {
        help.append(ident).append(commandName).appendln(" <cmd> [args]");
        ident = String.valueOf(ident) + "\t";
        for (String name : commands.keySet()) {
            try {
                Command command = commands.get(name).newInstance();
                if (command instanceof SubCommand) {
                    CommandUtil.appendCommandInfo(help, name, ((SubCommand)command).commands, ident);
                    continue;
                }
                CommandUtil.appendCommandDescription(help, name, command, ident);
            }
            catch (Exception e) {
                help.append(ident).append(name).append(" - ").appendln(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    static void executeCommand(CommandInterpreter ci, Class<? extends Command> cmdClass, String command, String parentCommandName, boolean printErrorDetails) {
        block11: {
            Command cmd;
            try {
                cmd = cmdClass.newInstance();
            }
            catch (Exception e) {
                ci.println((Object)("ERROR: " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
                return;
            }
            if (cmd instanceof SubCommand) {
                ((SubCommand)cmd).printErrorDetails = printErrorDetails;
                ((SubCommand)cmd).parentCommandName = parentCommandName;
            } else {
                boolean printHelp = false;
                ArrayList<String> args = new ArrayList<String>();
                String arg = ci.nextArgument();
                while (arg != null) {
                    if (CommandUtil.isHelpOption(arg)) {
                        printHelp = true;
                        break;
                    }
                    args.add(arg);
                    arg = ci.nextArgument();
                }
                CmdLineParser parser = new CmdLineParser((Object)cmd);
                if (printHelp) {
                    CommandUtil.printCommandHelp(ci, parentCommandName, command, parser);
                    return;
                }
                try {
                    parser.parseArgument(args.toArray(new String[args.size()]));
                }
                catch (CmdLineException e) {
                    ci.println((Object)("ERROR: " + e.getMessage()));
                    CommandUtil.printCommandHelp(ci, parentCommandName, command, parser);
                    return;
                }
            }
            try {
                cmd.execute(ci);
            }
            catch (Exception e) {
                ci.println((Object)("ERROR: " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
                if (!printErrorDetails) break block11;
                ci.printStackTrace((Throwable)e);
            }
        }
    }

    static boolean isHelpOption(String arg) {
        return StringUtils.equals((String)"-h", (String)arg) || StringUtils.equals((String)"--help", (String)arg);
    }

    static void printCommandHelp(CommandInterpreter ci, String name, String command, CmdLineParser parser) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(String.format("%s %s", name, command));
        parser.printSingleLineUsage((Writer)stringWriter, null);
        stringWriter.append(SystemUtils.LINE_SEPARATOR);
        parser.printUsage((Writer)stringWriter, null);
        stringWriter.flush();
        ci.println((Object)stringWriter.toString());
    }

    private CommandUtil() {
    }
}

