/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.gyrex.common.internal.applications.BaseApplication;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.util.WaitForJobToFinishJob;
import org.eclipse.gyrex.jobs.internal.worker.WorkerEngine;
import org.eclipse.gyrex.jobs.internal.worker.WorkerEngineMetrics;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerEngineApplication
extends BaseApplication {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerEngineApplication.class);
    private final WorkerEngineMetrics metrics = new WorkerEngineMetrics();
    private WorkerEngine workerEngine;
    private ServiceRegistration<MetricSet> metricsRegistration;

    protected void doCleanup() {
        WorkerEngine engine = this.workerEngine;
        if (engine != null) {
            this.workerEngine = null;
            engine.cancel();
        }
    }

    protected void doStart(Map arguments) throws Exception {
        if (JobsDebug.workerEngine) {
            LOG.debug("Starting worker engine application.");
        }
        this.metricsRegistration = JobsActivator.registerMetrics(this.metrics);
        this.workerEngine = new WorkerEngine(this.metrics);
        this.workerEngine.schedule();
    }

    protected Object doStop() {
        WorkerEngine engine = this.workerEngine;
        if (engine == null) {
            return EXIT_OK;
        }
        if (JobsDebug.workerEngine) {
            LOG.debug("Stopping worker engine application...");
        }
        this.workerEngine = null;
        if (!engine.cancel()) {
            try {
                int timeoutInSeconds = 30;
                LOG.info("Waiting {}s for worker engine to finish remaining work gracefully...", (Object)30);
                CountDownLatch wait = new CountDownLatch(1);
                WaitForJobToFinishJob job = new WaitForJobToFinishJob("Worker Engine Shutdown Job", engine, wait);
                job.schedule();
                if (!wait.await(30L, TimeUnit.SECONDS)) {
                    LOG.warn("Time out waiting for worker engine to finish remaining work. A complete restart (or shutdown) of the current process is recommended.");
                    return EXIT_ERROR;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (JobsDebug.workerEngine) {
            LOG.debug("Worker engine application engine stopped.");
        }
        if (this.metricsRegistration != null) {
            this.metricsRegistration.unregister();
            this.metricsRegistration = null;
        }
        return EXIT_OK;
    }

    protected Logger getLogger() {
        return LOG;
    }
}

