/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.http.internal.application.gateway.IHttpGateway;
import org.eclipse.gyrex.http.jetty.admin.ChannelDescriptor;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.gyrex.http.jetty.internal.HttpJettyActivator;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.JettyGateway;
import org.eclipse.gyrex.http.jetty.internal.connectors.CertificateSslContextFactory;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyEngineApplication
implements IApplication {
    private static final Logger LOG = LoggerFactory.getLogger(JettyEngineApplication.class);
    private static final String ORG_OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private static final Integer EXIT_ERROR = 1;
    private static final AtomicReference<CountDownLatch> stopSignalRef = new AtomicReference<Object>(null);
    private static final AtomicReference<Throwable> jettyErrorRef = new AtomicReference();
    private static Map<MetricSet, ServiceRegistration> metricsRegistrations = new ConcurrentHashMap<MetricSet, ServiceRegistration>();

    public static void forceShutdown() {
        CountDownLatch stopSignal = stopSignalRef.get();
        if (stopSignal != null) {
            stopSignal.countDown();
        }
    }

    public static ServiceRegistration registerMetrics(MetricSet metricSet) {
        ServiceRegistration metricsRegistration = HttpJettyActivator.getInstance().getServiceHelper().registerService(MetricSet.SERVICE_NAME, (Object)metricSet, "Eclipse Gyrex", metricSet.getDescription(), null, null);
        ServiceRegistration oldRegistration = metricsRegistrations.put(metricSet, metricsRegistration);
        if (oldRegistration != null && oldRegistration != metricsRegistration) {
            try {
                oldRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return metricsRegistration;
    }

    public static void unregisterMetrics(MetricSet metrics) {
        ServiceRegistration registration = metricsRegistrations.remove(metrics);
        if (registration != null) {
            try {
                registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void configureServer(Server server) {
        if (JettyDebug.engine) {
            LOG.debug("Configuring server {}", (Object)server);
        }
        Map<String, Object> nodeProperties = this.getNodeProperties();
        IJettyManager jettyManager = HttpJettyActivator.getInstance().getJettyManager();
        Collection<ChannelDescriptor> channels = jettyManager.getChannels();
        if (!channels.isEmpty()) {
            for (ChannelDescriptor channel : channels) {
                this.createConnector(server, channel, jettyManager, nodeProperties);
            }
        } else if (Platform.inDevelopmentMode()) {
            int port = Integer.getInteger(ORG_OSGI_SERVICE_HTTP_PORT, 8080);
            LOG.info("No channels configured. Enabling default channel on port {} in development mode.", (Object)port);
            ChannelDescriptor defaultChannel = new ChannelDescriptor();
            defaultChannel.setId("default");
            defaultChannel.setPort(port);
            this.createConnector(server, defaultChannel, jettyManager, nodeProperties);
        } else if (Integer.getInteger(ORG_OSGI_SERVICE_HTTP_PORT) != null) {
            int port = Integer.getInteger(ORG_OSGI_SERVICE_HTTP_PORT, 8080);
            LOG.info("No channels configured. Enabling channel on port {} configured via system property '{}'.", (Object)port, (Object)ORG_OSGI_SERVICE_HTTP_PORT);
            ChannelDescriptor defaultChannel = new ChannelDescriptor();
            defaultChannel.setId("default");
            defaultChannel.setPort(port);
            this.createConnector(server, defaultChannel, jettyManager, nodeProperties);
        }
        server.setStopAtShutdown(true);
        server.setStopTimeout(5000L);
    }

    private void createConnector(Server server, ChannelDescriptor channel, IJettyManager jettyManager, Map<String, Object> nodeProperties) {
        if (channel.getPort() <= 0 || channel.getPort() > 65535) {
            if (JettyDebug.engine) {
                LOG.debug("Ignoring disabled channel {}", (Object)channel);
            }
            return;
        }
        try {
            ChannelDescriptor secureChannel;
            Filter nodeFilter;
            String filter = channel.getNodeFilter();
            if (filter != null && !(nodeFilter = FrameworkUtil.createFilter((String)filter)).matches(nodeProperties)) {
                if (JettyDebug.engine) {
                    LOG.debug("Ignoring channel {} which has a node filter that does not match this node.", (Object)channel);
                }
                return;
            }
            if (JettyDebug.engine) {
                LOG.debug("Configuring channel {}", (Object)channel);
            }
            CertificateSslContextFactory sslFactory = null;
            if (channel.isSecure()) {
                ICertificate certificate = jettyManager.getCertificate(channel.getCertificateId());
                sslFactory = new CertificateSslContextFactory(certificate);
            }
            HttpConfiguration httpConfig = new HttpConfiguration();
            if (channel.getSecureChannelId() != null && (secureChannel = jettyManager.getChannel(channel.getSecureChannelId())) != null) {
                httpConfig.setSecurePort(secureChannel.getPort());
                httpConfig.setSecureScheme(HttpScheme.HTTPS.asString());
            }
            ServerConnector connector = this.createJettyConnector(server, sslFactory, httpConfig);
            connector.setPort(channel.getPort());
            connector.setIdleTimeout(200000L);
            server.addConnector((Connector)connector);
        }
        catch (Exception e) {
            LOG.warn("Error configuring channel {}. Please check the channel configuration. {}", (Object)channel.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private ServerConnector createJettyConnector(Server server, SslContextFactory sslFactory, HttpConfiguration httpConfig) {
        try {
            Class npnClass = HttpJettyActivator.getInstance().getBundle().loadClass("org.eclipse.jetty.npn.NextProtoNego");
            if (npnClass.getClassLoader() == null) {
                Class spdyConnectorClass = HttpJettyActivator.getInstance().getBundle().loadClass("org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnector");
                Constructor constructor = spdyConnectorClass.getConstructor(Server.class, HttpConfiguration.class, SslContextFactory.class, Map.class);
                return (ServerConnector)constructor.newInstance(server, httpConfig, sslFactory, null);
            }
            LOG.error("Jetty NPN not loaded via boot class loader. Falling back to non-SPDY setup. Please check your server setup (see http://wiki.eclipse.org/Jetty/Feature/NPN for details)! ({})", (Object)npnClass.getClassLoader());
        }
        catch (AssertionError | ClassNotFoundException | LinkageError e) {
            if (JettyDebug.engine) {
                LOG.debug("Jetty SPDY environment not available: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), e);
            }
        }
        catch (Exception e) {
            LOG.error("Error loading the Jetty SPDY implementation. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
        }
        LOG.info("Jetty SPDY environment not available. Using non SPDY implementation.");
        return new ServerConnector(server, sslFactory, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
    }

    private Map<String, Object> getNodeProperties() {
        INodeEnvironment nodeEnvironment = HttpJettyActivator.getInstance().getNodeEnvironment();
        HashMap<String, Object> nodeProperties = new HashMap<String, Object>(2);
        nodeProperties.put("id", nodeEnvironment.getNodeId());
        Set tags = nodeEnvironment.getTags();
        if (!tags.isEmpty()) {
            nodeProperties.put("tag", tags.toArray(new String[tags.size()]));
        }
        return nodeProperties;
    }

    boolean isActive() {
        CountDownLatch stopSignal = stopSignalRef.get();
        return stopSignal != null && stopSignal.getCount() > 0L;
    }

    void signalStopped(Throwable jettyError) {
        CountDownLatch signal;
        if (JettyDebug.engine) {
            LOG.debug("Received stop signal for Jetty engine.");
        }
        if ((signal = stopSignalRef.get()) != null) {
            jettyErrorRef.set(jettyError);
            signal.countDown();
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        CountDownLatch stopSignal;
        if (JettyDebug.engine) {
            LOG.debug("Starting Jetty engine.");
        }
        if (!stopSignalRef.compareAndSet(null, stopSignal = new CountDownLatch(1))) {
            throw new IllegalStateException("Jetty engine already running!");
        }
        try {
            Throwable error;
            int timeout = 5000;
            while (timeout > 0) {
                try {
                    CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http.jetty");
                    break;
                }
                catch (IllegalStateException e) {
                    if (!JettyDebug.engine) continue;
                    LOG.debug("Platform preferences not available. Jetty start will be delayed.");
                    try {
                        timeout -= 500;
                        Thread.sleep(500L);
                    }
                    catch (Exception e1) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            Server server = new Server();
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            server.addBean((Object)mbContainer);
            mbContainer.beanAdded((Container)server, (Object)Log.getRootLogger());
            JettyGateway gateway = new JettyGateway(server);
            this.configureServer(server);
            server.start();
            HttpGenerator.setServerVersion((String)"7");
            if (JettyDebug.engine) {
                LOG.debug("Jetty server started!");
                LOG.debug(server.dump());
            }
            ServiceRegistration gatewayServiceRegistration = HttpJettyActivator.getInstance().getServiceHelper().registerService(IHttpGateway.class.getName(), (Object)gateway, "Eclipse Gyrex", "Jetty based HTTP gateway.", null, null);
            if (JettyDebug.engine) {
                LOG.debug("Jetty HTTP gateway registered!");
                LOG.debug(server.dump());
            }
            context.applicationRunning();
            try {
                stopSignal.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            gatewayServiceRegistration.unregister();
            while (!metricsRegistrations.isEmpty()) {
                for (MetricSet metric : metricsRegistrations.keySet()) {
                    JettyEngineApplication.unregisterMetrics(metric);
                }
            }
            try {
                server.stop();
            }
            catch (Exception e) {
                if (JettyDebug.debug) {
                    LOG.warn("Error while stopping Jetty. {}", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                }
                LOG.warn("Error while stopping Jetty. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            if (gateway != null) {
                gateway.close();
                gateway = null;
            }
            if (JettyDebug.engine) {
                LOG.debug("Jetty engine shutdown complete.");
            }
            Integer n = (error = (Throwable)jettyErrorRef.getAndSet(null)) == null ? IApplication.EXIT_OK : EXIT_ERROR;
            return n;
        }
        catch (Exception e) {
            LOG.error("Unable to start Jetty. Please check the log files. System will be shutdown.", (Throwable)e);
            Integer n = EXIT_ERROR;
            return n;
        }
        finally {
            stopSignalRef.compareAndSet(stopSignal, null);
        }
    }

    public void stop() {
        this.signalStopped(null);
    }
}

