/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.externalprocess;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.externalprocess.AsyncLoggingInputStreamReader;
import org.eclipse.gyrex.server.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcessJob
extends Job {
    private static final Logger DEFAULT_LOG = LoggerFactory.getLogger(ExternalProcessJob.class);
    private final String jobId;
    private final List<String> command;
    private File workingDirectory;
    private final Logger log;
    private boolean clearEnvironment;
    private Map<String, String> additionalEnvironment;
    private int exitValue = 0;

    public ExternalProcessJob(String jobId, List<String> command, Logger log) {
        super(jobId);
        this.jobId = jobId;
        this.command = command;
        this.log = log != null ? log : DEFAULT_LOG;
        this.setPriority(30);
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException("Invalid job id: " + jobId);
        }
        if (command == null || command.isEmpty()) {
            throw new IllegalArgumentException("Command must not be null or empty!");
        }
    }

    public int getExitValue() {
        return this.exitValue;
    }

    /*
     * Could not resolve type clashes
     */
    protected IStatus run(IProgressMonitor monitor) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        this.log.debug("Command: {}", this.command);
        builder.command(this.command);
        if (this.workingDirectory != null) {
            this.log.debug("Using working directory: {}", (Object)this.workingDirectory);
            builder.directory(this.workingDirectory);
        }
        if (this.clearEnvironment) {
            builder.environment().clear();
            this.log.debug("Cleared environment!");
        } else {
            Iterator<Map.Entry<String, String>> entries = builder.environment().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, String> e = entries.next();
                if (!StringUtils.startsWithIgnoreCase((String)e.getKey(), (String)"gyrex")) continue;
                this.log.debug("Removing Gyrex specific environment variable: {}", (Object)e.getKey());
                entries.remove();
            }
        }
        this.setEnvironmentVariable(builder, "WORKSPACE", Platform.getInstanceLocation().toOSString());
        this.setEnvironmentVariable(builder, "JOB_ID", this.jobId);
        if (this.additionalEnvironment != null) {
            for (Map.Entry e : this.additionalEnvironment.entrySet()) {
                this.log.debug("Additional environment variable: {} = {}", e.getKey(), e.getValue());
                builder.environment().put((String)e.getKey(), (String)e.getValue());
            }
        }
        AsyncLoggingInputStreamReader inputStreamReader = null;
        AsyncLoggingInputStreamReader errorStreamReader = null;
        try {
            Process p = builder.start();
            inputStreamReader = new AsyncLoggingInputStreamReader(String.valueOf(this.jobId) + " [OUT Reader]", p.getInputStream(), this.log, AsyncLoggingInputStreamReader.Level.INFO);
            errorStreamReader = new AsyncLoggingInputStreamReader(String.valueOf(this.jobId) + " [ERR Reader]", p.getErrorStream(), this.log, AsyncLoggingInputStreamReader.Level.ERROR);
            int result = p.waitFor();
            if (result != this.exitValue) {
                Status status = new Status(4, "org.eclipse.gyrex.jobs", "Process finished with unexpected exit value: " + result);
                return status;
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for the process to finish.", (Throwable)e);
            Thread.currentThread().interrupt();
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (AssertionError | Exception | LinkageError e2) {
            this.log.error("Error starting process. {} ", (Object)((Throwable)e2).getMessage(), e2);
            Status status = new Status(4, "org.eclipse.gyrex.jobs", "Error starting process: " + ((Throwable)e2).getMessage(), (Throwable)e2);
            return status;
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (errorStreamReader != null) {
                errorStreamReader.close();
            }
        }
        if (StringUtils.isNotBlank((String)inputStreamReader.getLastLine())) {
            return new Status(0, "org.eclipse.gyrex.jobs", inputStreamReader.getLastLine());
        }
        return Status.OK_STATUS;
    }

    public void setAdditionalEnvironment(Map<String, String> additionalEnvironment) {
        this.additionalEnvironment = additionalEnvironment;
    }

    public void setClearEnvironment(boolean clearEnvironment) {
        this.clearEnvironment = clearEnvironment;
    }

    private void setEnvironmentVariable(ProcessBuilder builder, String key, String value) {
        this.log.debug("Setting environment variable: {} = {}", (Object)key, (Object)value);
        builder.environment().put(key, value);
    }

    public void setExitValue(int exitValue) {
        this.exitValue = exitValue;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }
}

