/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.textsize.BufferScrolledCompositeOriginsVisitor;
import org.eclipse.rap.rwt.internal.textsize.ClearLayoutBuffersVisitor;
import org.eclipse.rap.rwt.internal.textsize.EnlargeScrolledCompositeContentVisitor;
import org.eclipse.rap.rwt.internal.textsize.MarkLayoutNeededVisitor;
import org.eclipse.rap.rwt.internal.textsize.RePackVisitor;
import org.eclipse.rap.rwt.internal.textsize.RestoreScrolledCompositeOriginsVisitor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ControlUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class TextSizeRecalculation {
    static final String TEMPORARY_RESIZE = String.valueOf(TextSizeRecalculation.class.getName()) + "#temporaryResize";
    static final String KEY_SCROLLED_COMPOSITE_CONTENT_SIZE = "org.eclipse.rap.content-size";
    static final String KEY_SCROLLED_COMPOSITE_ORIGIN = "org.eclipse.rap.sc-origin";
    static final int RESIZE_OFFSET = 1000;

    TextSizeRecalculation() {
    }

    void execute() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            this.forceShellRecalculations(shells[i]);
            ++i;
        }
    }

    private void forceShellRecalculations(Shell shell) {
        boolean isPacked = ControlUtil.getControlAdapter(shell).isPacked();
        Rectangle boundsBuffer = shell.getBounds();
        this.bufferScrolledCompositeOrigins(shell);
        this.clearLayoutBuffers(shell);
        this.setTemporaryResize(true);
        this.enlargeShell(shell);
        this.enlargeScrolledCompositeContent(shell);
        this.setTemporaryResize(false);
        this.clearLayoutBuffers(shell);
        this.markLayoutNeeded(shell);
        this.rePack(shell);
        this.restoreShellSize(shell, boundsBuffer, isPacked);
        this.restoreScrolledCompositeOrigins(shell);
    }

    private void rePack(Shell shell) {
        WidgetTreeVisitor.accept(shell, new RePackVisitor());
    }

    private void clearLayoutBuffers(Shell shell) {
        WidgetTreeVisitor.accept(shell, new ClearLayoutBuffersVisitor());
    }

    private void markLayoutNeeded(Shell shell) {
        WidgetTreeVisitor.accept(shell, new MarkLayoutNeededVisitor());
    }

    private void bufferScrolledCompositeOrigins(Shell shell) {
        WidgetTreeVisitor.accept(shell, new BufferScrolledCompositeOriginsVisitor());
    }

    private void enlargeScrolledCompositeContent(Shell shell) {
        WidgetTreeVisitor.accept(shell, new EnlargeScrolledCompositeContentVisitor());
    }

    private void restoreScrolledCompositeOrigins(Shell shell) {
        WidgetTreeVisitor.accept(shell, new RestoreScrolledCompositeOriginsVisitor());
    }

    private void restoreShellSize(Shell shell, Rectangle bufferedBounds, boolean isPacked) {
        if (isPacked) {
            shell.pack();
        } else {
            this.setShellSize(shell, bufferedBounds);
        }
    }

    private void enlargeShell(Shell shell) {
        Rectangle bounds = shell.getBounds();
        int xPos = bounds.x;
        int yPos = bounds.y;
        int width = bounds.width + 1000;
        int height = bounds.height + 1000;
        this.setShellSize(shell, new Rectangle(xPos, yPos, width, height));
    }

    private Shell[] getShells() {
        return this.getShells(this.getDisplay());
    }

    private Display getDisplay() {
        return LifeCycleUtil.getSessionDisplay();
    }

    private Shell[] getShells(Display display) {
        IDisplayAdapter adapter;
        IDisplayAdapter displayAdapter = adapter = display.getAdapter(IDisplayAdapter.class);
        return displayAdapter.getShells();
    }

    private void setShellSize(Shell shell, Rectangle bounds) {
        shell.getAdapter(IShellAdapter.class).setBounds(bounds);
    }

    private void setTemporaryResize(boolean value) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        if (value) {
            serviceStore.setAttribute(TEMPORARY_RESIZE, Boolean.TRUE);
        } else {
            serviceStore.removeAttribute(TEMPORARY_RESIZE);
        }
    }
}

