/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.dragsourcekit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.internal.dnd.IDNDAdapter;
import org.eclipse.swt.internal.dnd.dragsourcekit.DNDLCAUtil;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Widget;

public final class DragSourceLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.DragSource";
    private static final String PROP_TRANSFER = "transfer";
    private static final String PROP_DRAG_START_LISTENER = "DragStart";
    private static final String PROP_DRAG_END_LISTENER = "DragEnd";
    private static final Transfer[] DEFAULT_TRANSFER = new Transfer[0];

    public void preserveValues(Widget widget) {
        DragSource dragSource = (DragSource)widget;
        WidgetLCAUtil.preserveProperty((Widget)dragSource, PROP_TRANSFER, dragSource.getTransfer());
        WidgetLCAUtil.preserveListener(dragSource, PROP_DRAG_START_LISTENER, EventLCAUtil.isListening(dragSource, 2008));
        WidgetLCAUtil.preserveListener(dragSource, PROP_DRAG_END_LISTENER, EventLCAUtil.isListening(dragSource, 2000));
    }

    public void readData(Widget widget) {
    }

    public void renderInitialization(Widget widget) throws IOException {
        DragSource dragSource = (DragSource)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(dragSource);
        clientObject.create(TYPE);
        clientObject.set("control", WidgetUtil.getId(dragSource.getControl()));
        clientObject.set("style", DNDLCAUtil.convertOperations(dragSource.getStyle()));
    }

    public void renderChanges(Widget widget) throws IOException {
        DragSource dragSource = (DragSource)widget;
        DragSourceLCA.renderTransfer(dragSource);
        this.renderDetail(dragSource);
        this.renderFeedback(dragSource);
        this.renderDataType(dragSource);
        DragSourceLCA.renderCancel(dragSource);
        WidgetLCAUtil.renderListener(dragSource, PROP_DRAG_START_LISTENER, EventLCAUtil.isListening(dragSource, 2008), false);
        WidgetLCAUtil.renderListener(dragSource, PROP_DRAG_END_LISTENER, EventLCAUtil.isListening(dragSource, 2000), false);
    }

    private static void renderTransfer(DragSource dragSource) {
        Transfer[] newValue = dragSource.getTransfer();
        if (WidgetLCAUtil.hasChanged(dragSource, PROP_TRANSFER, newValue, DEFAULT_TRANSFER)) {
            JsonArray renderValue = DNDLCAUtil.convertTransferTypes(newValue);
            ClientObjectFactory.getClientObject(dragSource).set(PROP_TRANSFER, renderValue);
        }
    }

    private void renderDetail(DragSource dragSource) {
        IDNDAdapter dndAdapter = dragSource.getAdapter(IDNDAdapter.class);
        if (dndAdapter.hasDetailChanged()) {
            JsonArray operations = DNDLCAUtil.convertOperations(dndAdapter.getDetailChangedValue());
            JsonObject parameters = new JsonObject().add("detail", operations.isEmpty() ? JsonValue.valueOf("DROP_NONE") : operations.get(0)).add("control", WidgetUtil.getId(dndAdapter.getDetailChangedControl()));
            ClientObjectFactory.getClientObject(dragSource).call("changeDetail", parameters);
        }
    }

    private void renderFeedback(DragSource dragSource) {
        IDNDAdapter dndAdapter = dragSource.getAdapter(IDNDAdapter.class);
        if (dndAdapter.hasFeedbackChanged()) {
            int value = dndAdapter.getFeedbackChangedValue();
            String feedbackChangedControlId = WidgetUtil.getId(dndAdapter.getFeedbackChangedControl());
            JsonObject parameters = new JsonObject().add("control", feedbackChangedControlId).add("flags", value).add("feedback", DragSourceLCA.convertFeedback(value));
            ClientObjectFactory.getClientObject(dragSource).call("changeFeedback", parameters);
        }
    }

    private void renderDataType(DragSource dragSource) {
        IDNDAdapter dndAdapter = dragSource.getAdapter(IDNDAdapter.class);
        if (dndAdapter.hasDataTypeChanged()) {
            String dataTypeChangedControlId = WidgetUtil.getId(dndAdapter.getDataTypeChangedControl());
            JsonObject parameters = new JsonObject().add("control", dataTypeChangedControlId).add("dataType", dndAdapter.getDataTypeChangedValue().type);
            ClientObjectFactory.getClientObject(dragSource).call("changeDataType", parameters);
        }
    }

    private static void renderCancel(DragSource dragSource) {
        IDNDAdapter dndAdapter = dragSource.getAdapter(IDNDAdapter.class);
        if (dndAdapter.isCanceled()) {
            ClientObjectFactory.getClientObject(dragSource).call("cancel", null);
        }
    }

    private static JsonArray convertFeedback(int feedback) {
        JsonArray feedbackNames = new JsonArray();
        if ((feedback & 0x10) != 0) {
            feedbackNames.add("FEEDBACK_EXPAND");
        }
        if ((feedback & 4) != 0) {
            feedbackNames.add("FEEDBACK_INSERT_AFTER");
        }
        if ((feedback & 2) != 0) {
            feedbackNames.add("FEEDBACK_INSERT_BEFORE");
        }
        if ((feedback & 8) != 0) {
            feedbackNames.add("FEEDBACK_SCROLL");
        }
        if ((feedback & 1) != 0) {
            feedbackNames.add("FEEDBACK_SELECT");
        }
        return feedbackNames;
    }
}

