/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.di.IRuntimeContextInjector;
import org.eclipse.gyrex.context.internal.GyrexContextImpl;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.preferences.IRuntimeContextPreferences;
import org.eclipse.gyrex.context.services.IRuntimeContextServiceLocator;
import org.osgi.framework.BundleContext;

public abstract class BaseContext
extends PlatformObject
implements IRuntimeContext {
    private final ContextRegistryImpl contextRegistry;
    private final IPath contextPath;

    public BaseContext(IPath contextPath, ContextRegistryImpl contextRegistry) {
        this.contextPath = contextPath;
        this.contextRegistry = contextRegistry;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IRuntimeContext)) {
            return false;
        }
        IRuntimeContext other = (IRuntimeContext)obj;
        return !(this.contextPath == null ? other.getContextPath() != null : !this.contextPath.toString().equals(other.getContextPath().toString()));
    }

    public GyrexContextImpl get() {
        return this.contextRegistry.getRealContext(this.contextPath);
    }

    @Override
    public <T> T get(Class<T> type) throws IllegalArgumentException {
        return this.get().get(type);
    }

    @Override
    public final IPath getContextPath() {
        return this.contextPath;
    }

    protected final ContextRegistryImpl getContextRegistry() {
        return this.contextRegistry;
    }

    @Override
    public IRuntimeContextInjector getInjector() {
        return this.get().getInjector();
    }

    @Override
    public IRuntimeContextPreferences getPreferences() {
        return this.get().getPreferences();
    }

    @Override
    public IRuntimeContextServiceLocator getServiceLocator(BundleContext bundleContext) {
        return this.get().getServiceLocator(bundleContext);
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = 31 * result + (this.contextPath == null ? 0 : this.contextPath.toString().hashCode());
        return result;
    }

    @Override
    public String toString() {
        return this.contextPath.toString();
    }
}

