/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.application.manager;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.context.IApplicationContext;
import org.eclipse.gyrex.http.internal.HttpActivator;
import org.eclipse.gyrex.http.internal.HttpDebug;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationInstance;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationRegistration.class);
    private static final Map<String, String> NO_INIT_PROPERTIES = Collections.emptyMap();
    private final String applicationId;
    private final String providerId;
    private final IRuntimeContext context;
    private final ConcurrentMap<IApplicationContext, ApplicationInstance> activeApplications = new ConcurrentHashMap<IApplicationContext, ApplicationInstance>(1);
    private final Lock applicationCreationLock = new ReentrantLock();
    private final ApplicationManager manager;
    private final List<DestroyListener> destoryListeners = new CopyOnWriteArrayList<DestroyListener>();

    public ApplicationRegistration(String applicationId, String providerId, IRuntimeContext context, ApplicationManager manager) {
        this.applicationId = applicationId;
        this.providerId = providerId;
        this.context = context;
        this.manager = manager;
    }

    public void addDestroyListener(DestroyListener listener) {
        this.destoryListeners.add(listener);
    }

    void destroy() {
        for (ApplicationInstance instance : this.activeApplications.values()) {
            instance.destroy();
        }
        this.activeApplications.clear();
        for (DestroyListener l : this.destoryListeners) {
            try {
                l.applicationDestroyed(this);
            }
            catch (Exception exception) {}
        }
        this.destoryListeners.clear();
    }

    public void destroyApplication(IApplicationContext applicationContext) {
        ApplicationInstance instance;
        Lock lock = this.applicationCreationLock;
        lock.lock();
        try {
            instance = (ApplicationInstance)this.activeApplications.remove(applicationContext);
        }
        finally {
            lock.unlock();
        }
        if (instance != null) {
            instance.destroy();
        }
    }

    public ApplicationInstance getApplication(IApplicationContext applicationContext) throws Exception {
        ApplicationProviderRegistration providerRegistration;
        ApplicationInstance instance = (ApplicationInstance)this.activeApplications.get(applicationContext);
        if (instance != null) {
            return instance;
        }
        if (HttpDebug.applicationLifecycle) {
            LOG.debug("Creating new application of type {} for context {}", (Object)this.providerId, (Object)applicationContext);
        }
        if ((providerRegistration = HttpActivator.getInstance().getProviderRegistry().getProviderRegistration(this.getProviderId())) == null) {
            return null;
        }
        Lock lock = this.applicationCreationLock;
        lock.lock();
        try {
            instance = (ApplicationInstance)this.activeApplications.get(applicationContext);
            if (instance != null) {
                ApplicationInstance applicationInstance = instance;
                return applicationInstance;
            }
            Application application = providerRegistration.createApplication(this);
            if (application == null) {
                return null;
            }
            instance = new ApplicationInstance(application, applicationContext);
            this.activeApplications.put(applicationContext, instance);
        }
        finally {
            lock.unlock();
        }
        return instance;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public IRuntimeContext getContext() {
        return this.context;
    }

    public Map<String, String> getInitProperties() {
        Map<String, String> p = this.manager.getProperties(this.applicationId);
        if (p != null) {
            return p;
        }
        return NO_INIT_PROPERTIES;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void removeDestroyListener(DestroyListener listener) {
        this.destoryListeners.remove(listener);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ApplicationRegistration [applicationId=").append(this.applicationId).append(", providerId=").append(this.providerId).append(", context=").append(this.context.getContextPath()).append(", activeApplications=").append(this.activeApplications.size()).append("]");
        return builder.toString();
    }

    public static interface DestroyListener {
        public void applicationDestroyed(ApplicationRegistration var1);
    }
}

