/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.gyrex.jobs.internal.scheduler.SchedulingJob;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.worker.JobContext;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleManager;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TriggerScheduleEntriesWhenDone
extends JobChangeAdapter {
    private final String[] scheduleInfo;
    private final JobContext jobContext;
    private static final Logger LOG = LoggerFactory.getLogger(TriggerScheduleEntriesWhenDone.class);

    public TriggerScheduleEntriesWhenDone(String[] scheduleInfo, JobContext jobContext) {
        this.scheduleInfo = scheduleInfo;
        this.jobContext = jobContext;
    }

    public void done(IJobChangeEvent event) {
        IStatus result = event.getResult();
        if (result.isOK() || result.matches(3)) {
            this.triggerDependentJobsAfterSuccess();
        }
    }

    private void triggerDependentJobsAfterSuccess() {
        if (this.scheduleInfo.length <= 2) {
            LOG.debug("No dependent jobs to trigger after run.");
            return;
        }
        IScheduleManager scheduleManager = (IScheduleManager)this.jobContext.getContext().get(IScheduleManager.class);
        if (scheduleManager == null) {
            LOG.debug("Schedule manager not available.");
            return;
        }
        ScheduleImpl schedule = (ScheduleImpl)scheduleManager.getSchedule(this.scheduleInfo[0]);
        if (schedule == null) {
            LOG.debug("Schedule {} removed.", (Object)this.scheduleInfo[0]);
            return;
        }
        ScheduleEntryImpl entry = schedule.getEntry(this.scheduleInfo[1]);
        if (entry == null) {
            LOG.debug("Schedule entry {} removed from schedule {}.", (Object)this.scheduleInfo[1], (Object)this.scheduleInfo[0]);
            return;
        }
        int i = 2;
        while (i < this.scheduleInfo.length) {
            ScheduleEntryImpl entryToRun = schedule.getEntry(this.scheduleInfo[i]);
            if (entryToRun != null) {
                LOG.debug("Trigger dependent entry {}.", (Object)entryToRun.getId());
                try {
                    JobDataMap dataMap = new JobDataMap();
                    SchedulingJob.populateJobDataMap(dataMap, entryToRun, schedule);
                    SchedulingJob.queueJob(dataMap);
                }
                catch (Exception e) {
                    LOG.error("Unable to schedule entry {}. {}", new Object[]{entryToRun.getId(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                }
            } else {
                LOG.debug("Dependent entry {} not found in schedule {}.", (Object)this.scheduleInfo[i], (Object)schedule.getId());
            }
            ++i;
        }
    }
}

