/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.scalekit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Widget;

public final class ScaleLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Scale";
    private static final String[] ALLOWED_STYLES = new String[]{"HORIZONTAL", "VERTICAL", "BORDER"};
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_SELECTION = "selection";
    static final String PROP_INCREMENT = "increment";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    static final String PROP_SELECTION_LISTENER = "Selection";
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_SELECTION = 0;
    private static final int DEFAULT_INCREMENT = 1;
    private static final int DEFAULT_PAGE_INCREMENT = 10;

    public void preserveValues(Widget widget) {
        Scale scale = (Scale)widget;
        ControlLCAUtil.preserveValues(scale);
        WidgetLCAUtil.preserveCustomVariant(scale);
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_MINIMUM, scale.getMinimum());
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_MAXIMUM, scale.getMaximum());
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_SELECTION, scale.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_INCREMENT, scale.getIncrement());
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_PAGE_INCREMENT, scale.getPageIncrement());
        WidgetLCAUtil.preserveListener(scale, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(scale, 13));
    }

    public void readData(Widget widget) {
        Scale scale = (Scale)widget;
        String value = WidgetLCAUtil.readPropertyValue(scale, PROP_SELECTION);
        if (value != null) {
            scale.setSelection(NumberFormatUtil.parseInt(value));
        }
        ControlLCAUtil.processSelection(scale, null, true);
        ControlLCAUtil.processKeyEvents(scale);
        ControlLCAUtil.processMouseEvents(scale);
        ControlLCAUtil.processMenuDetect(scale);
        WidgetLCAUtil.processHelp(scale);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Scale scale = (Scale)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(scale);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(scale.getParent()));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(scale, ALLOWED_STYLES)));
    }

    public void renderChanges(Widget widget) throws IOException {
        Scale scale = (Scale)widget;
        ControlLCAUtil.renderChanges(scale);
        WidgetLCAUtil.renderCustomVariant(scale);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_MINIMUM, scale.getMinimum(), 0);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_MAXIMUM, scale.getMaximum(), 100);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_SELECTION, scale.getSelection(), 0);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_INCREMENT, scale.getIncrement(), 1);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_PAGE_INCREMENT, scale.getPageIncrement(), 10);
        WidgetLCAUtil.renderListener(scale, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(scale, 13), false);
    }
}

